<?php $this->extend('layouts\master') ?>

<?php $this->section('unitandmeatures') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#unitsModal">
                                                        <i class="bi bi-plus-lg fw-bold"></i> Units
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#cfModal">
                                                         <a href="/conversion_factor" class="text-secondary text-decoration-none">    
                                                             Add Conversion Factor
                                                        </a>
                                                    </button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col"> Unit</th>
                                            <th class="p-2" scope="col">Unit Abbreviation</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($allunits):
                                                foreach($allunits as $allunit): 
                                            ?>
                                            <tr id="<?php echo $allunit['UnitID']; ?>"> 
                                                <td><?php echo $allunit['UnitName']; ?></td>
                                                <td><?php echo $allunit['UnitAbbreviation']; ?></td>
                                                <td>
                                                     <button class="btn linear-bg text-secondary px-2 py-0" id="unitedit" type="button"   data-id="<?php echo $allunit['UnitID']; ?>"  data-bs-toggle="modal"   data-bs-target="#unitsModal">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="unitdelete" type="button" data-id="<?php echo $allunit['UnitID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--  start End insert and update  unit detail model -->
        <div class="modal fade" id="unitsModal" tabindex="-1" aria-labelledby="unitsModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="unitsModalLabel">Units Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <form method="post" id="addupunits" name="addupunits" action="/addupunit">
                            <input type="hidden" class="form-control"  value="<?php echo set_value('UnitID');?>"  name="UnitID" id="UnitID" placeholder="Enter Unit Name">
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="UnitName" id="UnitName" value="<?php echo set_value('UnitName');?>" placeholder="Enter Unit Name">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'UnitName') : '' ?></h6>
                                    </div>
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="UnitAbbre" value="<?php echo set_value('UnitAbbre');?>" id="UnitAbbre" placeholder="Enter Unit Abbreviation">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'UnitAbbre') : '' ?></h6>
                                    </div>
                                </div>                       
                                <div class="row">
                                    <div class="mb-3 col">
                                        <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                                    </div>                            
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     <!-- End insert and update  unit detail model  -->
    
    </section>
    <?php echo view('includes/footer'); ?>
    
    <script>

        function openUOMModal(){
            var uom_modal = $("#unitsModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                uom_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openUOMModal();
            $('#viewtable, #viewunits').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable, #viewunits').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });
        
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        
        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                

        //update unit
        $('body').on('click', '#unitedit', function () {
            var unit_id = $(this).attr('data-id');
            $.ajax({
                url: 'unitedit/'+unit_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#addupunits #UnitID').val(res.data.UnitID); 
                    $('#addupunits #UnitName').val(res.data.UnitName); 
                    $('#addupunits #UnitAbbre').val(res.data.UnitAbbreviation);
                },
                    error: function (data) {
                        console.log('errr');
                }
            });
        });

          $('body').on('click', '#unitdelete', function () {
              var unitid = $(this).attr('data-id');
            //  alert(unitid);
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ unitid).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'unitdeleted/'+unitid,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable tbody #'+ unitid).remove();
                            }
                        }
                    });
                }
            });          
        });
        
                
            //reset form
            $('#unitsModal').on('hidden.bs.modal', function (e) {
                // Clear the form fields
                $(this).find('form').trigger('reset');
                $(this).find('.text-danger').remove();
            });
      
        //Disable selected value in ToUnit
        // $("#cfFromUnit").change(function(){
        //     var fuvalue = $(this).val();
        //     $("#cfToUnit #"+fuvalue).attr('disabled','disabled');
        //     console.log(fuvalue);
        // });

        // $('select').change(function() {
        //     var value = $(this).val();
        //     //alert(value);
        //     $(this).siblings('select').children('option').each(function() {
        //         if ( $(this).val() === value ) {
        //             $(this).attr('disabled', true).siblings().removeAttr('disabled');   
        //         }
        //     });
        // });
    </script>
<?php $this->endSection() ?>