<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'item';
    protected $primaryKey       = 'ItemID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ItemImg', 'ItemCategory', 'ItemTags', 'ItemDescription', 'ItemUnit', 'ItemReorderLevel', 'ItemIsSerialized', 'ItemCreatedAt', 'ItemUpdatedAt', 'ItemDeletedAt', 'ItemStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ItemCreatedAt';
    protected $updatedField  = 'ItemUpdatedAt';
    protected $deletedField  = 'ItemDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all Item Data
    function getItemIndexData()
    {
        return $this->db
            ->table('item') 
                ->join('itemcategory', 'itemcategory.ICID = item.ItemCategory')
                ->join('units', 'item.ItemUnit = units.UnitID')
            ->orderBy('ItemID ', 'ASC')
            ->get()
            ->getResultArray();
    }

    // Insert Item Data
    function insertItemData($data)
    {
        return $this->db
            ->table('item')
            ->insert($data);
    }

    // get single item category data
    function getSingleItemData($id)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID " => $id])
            ->get()
            ->getRow();
    }
    
    // update employee
    function updateItem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }

    // delete item
    function deleteitem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }

    // item status & serialize status change
    function statusupdate($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }
    //get item data by item id
    function getItemData($id){
        $item_master_data = $this->db->table('item')->where(["ItemID" => $id])->get()->getRow();
        $item_receiving_data = $this->db->table('receivingdetails')->where(["ItemID" => $id])->get()->getResultArray();
        $item_selling_price_arr_all = [];
        for($i=0;$i<count($item_receiving_data);$i++){
            array_push($item_selling_price_arr_all,$item_receiving_data[$i]['RDSellingPrice']);
        }
        $item_selling_price_arr = array_unique($item_selling_price_arr_all);
        $data['item_id'] = $id;
        $data['item_name'] = $item_master_data->ItemName;
        $data['selling_price'] = $item_selling_price_arr;
        return $data;
    }
}
