<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Delivery extends Migration
{
    public function up()
    {
        //Create Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'sale_id' => [
                'type' => 'INT',
            ],
            'customer_id' => [
                'type' => 'INT',
            ],
            'emp_id' => [
                'type' => 'INT',
            ],
            'address' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'phone_number' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'estimated_shipping_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'estimated_delivery_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'actual_shipping_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'actual_delivery_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        // $this->forge->addForeignKey('SaleID', 'sales', 'SaleID', 'CASCADE', 'CASCADE');
        // $this->forge->addForeignKey('CustomerID', 'customers', 'CusId', 'CASCADE', 'CASCADE');
        // $this->forge->addForeignKey('EmpID', 'employee', 'EmpID', 'CASCADE', 'CASCADE');
        $this->forge->createTable('delivery');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('delivery');
    }
}
