<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Item extends Migration
{
    public function up()
    {
        //Create Item Table
        $this->forge->addField([
            'ItemID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ItemCategory' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemTags' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemDescription' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemUnit' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemReorderLevel' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemIsSerialized' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ItemStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ItemID');
        $this->forge->createTable('item');
    }

    public function down()
    {
        //Drop Item Table
        $this->forge->dropTable('item');
    }
}
