<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Aisie extends Migration
{
    public function up()
    {
        //Create Aisie Table
        $this->forge->addField([
            'AisieID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'AisieName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ZoneID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'AisieCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'AisieUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'AisieDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'AisieStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('AisieID');
        $this->forge->createTable('aisie');
    }

    public function down()
    {
        //Drop Aisie Table
        $this->forge->dropTable('aisie');
    }
}
