<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class RuleBook extends Migration
{
    public function up()
    {
        //Create RuleBook Table
        $this->forge->addField([
            'RBID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RoleID' => [
                'type' => 'INT',
            ],
            'UserID' => [
                'type' => 'INT',
            ],
            'FID' => [
                'type' => 'INT',
            ],
            'RBCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('RBID');
        $this->forge->createTable('rulebook');
    }

    public function down()
    {
        //Drop RuleBook Table
        $this->forge->dropTable('rulebook');
    }
}
