<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class User extends Migration
{
    public function up()
    {
        //Create User Table
        $this->forge->addField([
            'UserID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'EmpID' => [
                'type' => 'INT',
            ],            
            'UserRole' => [
                'type' => 'INT',
            ],
            'UserName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UserPassword' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UserCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('UserID');
        $this->forge->createTable('user');
    }

    public function down()
    {
        //Drop User Table
        $this->forge->dropTable('user');
    }
}
