<?php

namespace App\Controllers;
use App\Models\UserRoleModel;
use App\Models\UserModel;

use App\Controllers\BaseController;

class UserRoleController extends BaseController
{

    public function __construct(){
        
        $this->userroleModel = new UserRoleModel();
        helper(['url','form','app']);
    }


    
    // insert data
    public function insert() {
        $validation = $this->validate([
            'URName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Uname is required',
                ],
            ],
        ]);
        $uroleId = $this->request->getVar('URoleID');
        if($validation){   
            if($uroleId == ''){  //insert userrole details      
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'URStatus' => '1',
                    'URCreatedAt'=>date('Y-m-d H:i:s'),
                ];
           
                $this->userroleModel->insertuRoleData($data);
            }
            else{      //update userrole details
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'URUpdatedAt' => date('Y-m-d H:i:s'),
                ];        
                $this->userroleModel->updateUrole($uroleId, $data);
            }
             return $this->response->redirect(site_url('/userroles'));
                 }
        else{
            $has_errors = 'true';
            $user_info = getUserInfo(); 
            $urs['UserRoles']= $this->userroleModel->getUrolesIndexData();
            $data = [
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'breadcrumbs' => 'true',
                'title' => 'User Roles',
                'link' => 'userroles',
                'sources' => $urs,
                'userinfo' => $user_info
            ];
            return view('/userroles', $data); 
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $urs['UserRoles']= $this->userroleModel->getUrolesIndexData();
        $has_errors = 'false';
        
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'User Roles',
            'link' => 'userroles',
            'sources' => $urs,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('userroles', $data);
    }
    //get single data
    public function singleData($id = null) {        
        $data= $this->userroleModel->getSingleuRoleData($id);
        if($data){
            echo json_encode(array("status" => true, 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }


    // delete
    public function delete($id = null){
        $now = date("Y-m-d H:i:s");
        $data = [
            'URDeletedAt' => $now,
            'URStatus' => '0',
        ];
        // $UserRoleModel->update($id, $data);
        $this->userroleModel->deleteUrole($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        //return $this->response->redirect(site_url('/functionality'));
    } 
}
