<?php

namespace App\Models;

use CodeIgniter\Model;

class PrModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'price_rules';
    protected $primaryKey       = 'pr_id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['pr_type', 'pr_name', 'pr_value', 'pr_items', 'pr_bank', 'pr_rate', 'pr_started_date', 'pr_end_date', 'pr_created_at','pr_updated_at','pr_deleted_at','pr_status','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'pr_created_at';
    protected $updatedField  = 'pr_updated_at';
    protected $deletedField  = 'pr_deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    // get all PriceRules data
    function getIndexpRuleData(){
        $data= $this->db
        ->table('price_rules')
        ->where('pr_status', '1')
        ->orderBy('pr_id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }
    // save PriceRules data
    function insertPriceRulesData($data)
	{
        return $this->db
        ->table('price_rules')
        ->insert($data);
	}
    // get single PriceRules data
    function getSinglePruleData($id){

        return $this->db
             ->table('price_rules')
             ->where(["pr_id" => $id])
             ->get()
             ->getRow();

    }  
    // update PriceRules
    function updatePriceRulesData($id,$data){

        // print_r($data);
        // die();
        return $this->db
        ->table('price_rules')
        ->where(["pr_id" => $id])
        ->set($data)
        ->update();

    }
    // delete PriceRules
    function deletePrule($id,$data){
        return $this->db
        ->table('price_rules')
        ->where(["pr_id" => $id])
        ->set($data)
        ->update();

    }
    

}
