<?php

namespace App\Models;

use CodeIgniter\Model;

class BinModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'bin';
    protected $primaryKey       = 'BinID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['BinName', 'ShelfID', 'BinSpace', 'BinCreaterAt', 'BinUpdatedAt', 'BinDeletedAt', 'BinStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'BinCreaterAt';
    protected $updatedField  = 'BinUpdatedAt';
    protected $deletedField  = 'dAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
