<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\UnitsModel;
use App\Models\ConversionFactorModel;
use App\Controllers\BaseController;
use Config\Services;

class ConversionFactorController extends BaseController
{
    private $UserModel = null;
    private $UnitsModel = null;
    private $ConversionFactorModel = null;
    private $now = null;

    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->UnitsModel = new UnitsModel();
        $this->ConversionFactorModel = new ConversionFactorModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
        $this->db = \Config\Database::connect();
        $this->validation = Services::validation();
    }
    public function index()
    {        
        $user_info = getUserInfo(); 
        $allunits = $this->UnitsModel->getAllActiveUnitsData();
        $allCFs = $this->ConversionFactorModel->getAllCFsData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Unit & Meatures',
            'link' => 'unitandmeatures',
            'userinfo' => $user_info,
            'allunits' => $allunits,
            'allCFs' => $allCFs,
            'has_errors' =>$has_errors,
        );    
        return view('unitconversionfactors', $data);
    }
    // add CF data
    public function addupCFs()
    { 
        $user_info = getUserInfo();   
        $validation = $this->validate([
            'cfFromUnit' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'cfToUnit' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'cfFactor' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter value',
                ],
            ],
        ]);

        if($validation){
            $session = session();
            $cfID = $this->request->getVar('cfID');
            $cfFromUnit = $this->request->getVar('cfFromUnit');
            $cfToUnit = $this->request->getVar('cfToUnit');
            $results = $this->ConversionFactorModel->checkData($cfFromUnit,$cfToUnit);
            // var_dump($results);
            if($cfID == ''){  //insert cf details
                $data = [
                    'FromUnitiD' => $this->request->getVar('cfFromUnit'),
                    'ToUnitID'  => $this->request->getVar('cfToUnit'),
                    'CFFactor'  => $this->request->getVar('cfFactor'),
                    'CFCreatedAt' => $this->now,
                    'CFCreatedBy' =>$user_info->UserID,
                    'delete_flag' => '0',
                ];
                if($results == null){                    
                     //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();
                    $this->ConversionFactorModel->insertCFs($data);
                    if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                           // Set the success flash message
                        $session->setFlashdata('title', 'Error');
                        $session->setFlashdata('icon', 'warning');
                        $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                       // Set the success flash message
                        $session->setFlashdata('title', 'Saved');
                        $session->setFlashdata('icon', 'success');
                        $session->setFlashdata('message', 'Convertion Factor  details saved successfully.'); 
                    }           
                }
                else
                {
                    // Set the success flash message
                    $session->setFlashdata('title', 'Duplicate entry found');
                    $session->setFlashdata('icon', 'error');
                    $session->setFlashdata('message', 'Conversion Factor already added to system. Try again!');
                }
            }
            else{  //update cf 
                $data = [
                    'FromUnitiD' => $this->request->getVar('cfFromUnit'),
                    'ToUnitID'  => $this->request->getVar('cfToUnit'),
                    'CFFactor'  => $this->request->getVar('cfFactor'),
                    'CFUpdatedAt' => $this->now,
                    'CFUpdatedBy' => $user_info->UserID,
                ];
                
                if($results == null){  
                    $this->ConversionFactorModel->updateCFs($cfID, $data);
                    
                    // Set the success flash message
                    $session->setFlashdata('title', 'Updated');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Convertion Factor added successfully!');
                }else{
                    // Set the success flash message
                    $session->setFlashdata('title', 'Duplicate entry found');
                    $session->setFlashdata('icon', 'error');
                    $session->setFlashdata('message', 'Conversion Factor already added to system. Try again!');
                }
            }
            return $this->response->redirect(site_url('/conversion_factor'));
        }
        else{
            $user_info = getUserInfo(); 
            $allunits = $this->UnitsModel->getIndexData();
            $allCFs = $this->ConversionFactorModel->getAllCFsData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Unit & Meatures',
                'link' => 'unitandmeatures',
                'userinfo' => $user_info,
                'allunits' => $allunits,
                'allCFs' => $allCFs,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('unitconversionfactors', $data);
        }
    }

    //get single CF
    public function singleCFs($id = null)
    {
        $data = $this->ConversionFactorModel->getSingleCFData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete CFs
    public function deleteCF($id = null)
    {
        $user_info = getUserInfo();   
        $data = [
            'CFDeletedAt' => $this->now,
            'CFDeletedBy' => $user_info->UserID,
            'delete_flag' => '1',
        ];

        $this->ConversionFactorModel->deleteCFs($id, $data);

        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }

     // unit disable
     public function disableconversionfactor($id = null)
     {
         $data = [
             'current_status' => '2'
         ];         
         if($this->ConversionFactorModel->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
     // unit enable
     public function enableconversionfactor($id = null)
     {
         $data = [
             'current_status' => '1'
         ];
         if($this->ConversionFactorModel->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
}
