<?php $this->extend('layouts/master') ?>

<?php $this->section('suppliers') ?>

        <!---List of supplier --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#supplierModal"><i class="bi bi-plus-lg fw-bold"></i> New Supplier </button>
                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Company Name</th>
                                            <th class="p-2" scope="col">Sup Name</th>
                                            <th class="p-2" scope="col">Address</th>
                                            <th class="p-2" scope="col">E-mail</th>
                                            <th class="p-2" scope="col">Phone Number</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">
                                        <?php 
                                            if($sources):
                                            foreach($sources as $source): 
                                            foreach($source as $s): 
                                        ?>
                                            <tr id="<?php echo $s['SupplierID']; ?>">
                                                 <td><?php echo $s['SupplierCompanyName']; ?></td>
                                                 <td><?php echo $s['SupplierName']; ?></td>
                                                 <td><?php echo $s['SupplierAddressLine1']; ?></td>
                                                 <td><?php echo $s['SupplierEmail']; ?></td>
                                                 <td><?php echo $s['SupplierContactNo']; ?></td>
                                                 <td>
                                                        <?php 
                                                                if($s['current_status'] == '1'):
                                                            ?>
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['SupplierID']; ?>" checked/>
                                                                </div>
                                                            <?php
                                                                else:
                                                            ?>
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['SupplierID']; ?>" />
                                                                </div>
                                                            <?php
                                                                endif;
                                                            ?>
                                                    </td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="suppedit" type="button" data-bs-toggle="modal" 
                                                    data-bs-target="#supplierModal" data-id="<?php echo $s['SupplierID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="suppdelete" type="button" data-id="<?php echo $s['SupplierID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                            endforeach;
                                            endforeach;
                                            endif;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Start Insert and Update Suppliers --->
        <div class="modal fade with-img-upload" id="supplierModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> Supplier Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?= site_url('/supplier_save') ?>" id="add_supp"  method="post" accept-charset="utf-8"  enctype="multipart/form-data">
                            <div class="row">
                                <div class="mb-3 wrapper col">
                                    <div class="box">
                                        <div class="js--image-preview">
                                        <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                        </div>
                                        <div class="upload-options">
                                            <label>
                                                <input type="file" class="image_upload" accept="image/*" name="SuppImg" id="SuppImg">
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                <input type="hidden" class="form-control mb-3" name="SupplierID" id="SupplierID" hidden  value="<?php echo set_value('SupplierID');?>">
                                        <label for="companyname" class="col-form-label">Enter Company Name:</label>         
                                        <input type="text" class="form-control" name="SupplierCompanyName" id="SupplierCompanyName" value="<?php echo set_value('SupplierCompanyName');?>"  placeholder="Enter Company Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCompanyName') : '' ?></h6>
                                </div>
                            
                                <div class="mb-3 col">
                                        <label for="companybr" class="col-form-label">Enter Company BR No:</label>  
                                    <input type="text" class="form-control" name="SupplierBRNo" id="SupplierBRNo" value="<?php echo set_value('SupplierBRNo');?>" placeholder="Enter Company BR No">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBRNo') : '' ?></h6>
                                </div>
                                
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="suppname" class="col-form-label">Enter Contact Person Name:</label>  
                                    <input type="text" class="form-control" name="SupplierName" value="<?php echo set_value('SupplierName');?>" id="SupplierName" placeholder="Enter Supplier Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierName') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="cntact" class="col-form-label"> Contact Person Phone Number:</label> 
                                    <input type="tel" class="form-control phone_number" name="SupplierContactNo" value="<?php echo set_value('SupplierContactNo');?>" id="SupplierContactNo" >
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierContactNo') : '' ?></h6>
                                </div>
                            </div>
                           
                            <div class="row">
                                <div class="mb-3 col">
                                        <label for="email" class="col-form-label">Enter the Email:</label> 
                                    <input type="email" class="form-control" name="SupplierEmail"value="<?php echo set_value('SupplierEmail');?>"  id="SupplierEmail" placeholder="Enter the Email">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierEmail') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="add1" class="col-form-label">Enter Address :</label>  
                                    <input type="text" class="form-control" name="SupplierAddressLine1" value="<?php echo set_value('SupplierAddressLine1');?>"   id="SupplierAddressLine1" placeholder="Enter Address">
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="email" class="col-form-label">Select Payment Term:</label> 
                                    <select class="form-control" name="payment_term" id="payment_term">
                                      <option value="">--Select Payment Term--</option>
                                        <?php foreach($payment_terms as $payment_term){?>
                                            <option value="<?php echo $payment_term['id'] ;?>" <?php echo set_value('payment_term') ==  $payment_term['id'] ? 'selected' : ''; ?>><?php echo $payment_term['payment_term_name'].'- '.$payment_term['payment_term_value'];?></option>
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'payment_term') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="city" class="col-form-label">Enter the City:</label>  
                                    <input type="text" class="form-control" name="SupplierCity" value="<?php echo set_value('SupplierCity');?>" id="SupplierCity" placeholder="Enter the City">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCity') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="province" class="col-form-label">Enter the Province:</label>  
                                    <input type="text" class="form-control" name="SupplierProvince" value="<?php echo set_value('SupplierProvince');?>" id="SupplierProvince" placeholder="Enter the Province">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierProvince') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="country" class="col-form-label">Enter the Country:</label> 
                                    <input type="text" class="form-control" name="SupplierCountry"  value="<?php echo set_value('SupplierCountry');?>" id="SupplierCountry" placeholder="Enter the Country">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCountry') : '' ?></h6>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="mb-3 col">
                                        <label for="supplierdesc" class="col-form-label">Enter Suppliers Description:</label> 
                                    <textarea class="form-control" name="SupplierDescription" value="" id="SupplierDescription" placeholder="Enter Suppliers Description"><?php echo set_value('SupplierDescription');?></textarea>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierDescription') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                <label for="bnk" class="col-form-label">Enter the Supplier's Bank:</label> 
                                <input type="text" class="form-control" name="SupplierBankName" value="<?php echo set_value('SupplierBankName');?>"  id="SupplierBankName" placeholder="Enter Supplier's Bank">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBankName') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">
                                <label for="bnkno" class="col-form-label">Enter Supplier's Bank No:</label> 
                                <input type="text" class="form-control" name="SupplierBankACNo" value="<?php echo set_value('SupplierBankACNo');?>"  id="SupplierBankACNo" placeholder="Enter Supplier's Bank No">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBankACNo') : '' ?></h6>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                        </div>
                    </div>
                </form>
                </div>
            </div>
        </div>
       
        <!--- end Insert and Update Suppliers  --->
    </section>
    
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage)
         {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
         function openSupplierModal()
         {
            var sup_modal = $("#supplierModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                sup_modal.modal('show');
            }
        }
        $(document).ready(function() 
        {
            openSupplierModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            SuppTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                SuppTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    SuppTable.rows().select();        
                } else {
                    SuppTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
    </script>
    <script>
        function initImageUpload(box)
         {
            let uploadField = box.querySelector('.image_upload');
            uploadField.addEventListener('change', getFile);
            function getFile(e) {
                let file = e.currentTarget.files[0];
                checkType(file);
            }
            function previewImage(file) {
                let thumb = box.querySelector('.js--image-preview'),
                    reader = new FileReader();
                reader.onload = function () {
                    thumb.style.backgroundImage = 'url(' + reader.result + ')';
                }
                reader.readAsDataURL(file);
                thumb.className += ' js--no-default';
            }
            function checkType(file) {
                let imageType = /image.*/;
                if (!file.type.match(imageType)) {
                    throw 'Datei ist kein Bild';
                } else if (!file) {
                    throw 'Kein Bild gewählt';
                } else {
                    previewImage(file);
                }
            }
         }
        // initialize box-scope
        var boxes = document.querySelectorAll('.box');
        for (let i = 0; i < boxes.length; i++) {
            let box = boxes[i];
            initDropEffect(box);
            initImageUpload(box);
        }
        /// drop-effect
        function initDropEffect(box) 
        {
            let area, drop, areaWidth, areaHeight, maxDistance, dropWidth, dropHeight, x, y;
            // get clickable area for drop effect
            area = box.querySelector('.js--image-preview');
            area.addEventListener('click', fireRipple);
            function fireRipple(e) {
                area = e.currentTarget
                // create drop
                if (!drop) {
                    drop = document.createElement('span');
                    drop.className = 'drop';
                    this.appendChild(drop);
                }
                // reset animate class
                drop.className = 'drop';
                // calculate dimensions of area (longest side)
                areaWidth = getComputedStyle(this, null).getPropertyValue("width");
                areaHeight = getComputedStyle(this, null).getPropertyValue("height");
                maxDistance = Math.max(parseInt(areaWidth, 10), parseInt(areaHeight, 10));
                // set drop dimensions to fill area
                drop.style.width = maxDistance + 'px';
                drop.style.height = maxDistance + 'px';
                // calculate dimensions of drop
                dropWidth = getComputedStyle(this, null).getPropertyValue("width");
                dropHeight = getComputedStyle(this, null).getPropertyValue("height");
                // calculate relative coordinates of click
                // logic: click coordinates relative to page - parent's position relative to page - half of self height/width to make it controllable from the center
                x = e.pageX - this.offsetLeft - (parseInt(dropWidth, 10) / 2);
                y = e.pageY - this.offsetTop - (parseInt(dropHeight, 10) / 2) - 30;
                // position drop and animate
                drop.style.top = y + 'px';
                drop.style.left = x + 'px';
                drop.className += ' animate';
                e.stopPropagation();
            }
        }
        // update employe
        $('body').on('click', '#suppedit', function () 
        { 
            var SupID = $(this).attr('data-id');
            $.ajax({
                url: 'supplier_edit/'+SupID,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#supplierModal').modal('show');
                    console.log(res.data)
                    $('#add_supp #SupplierCompanyName').val(res.data.SupplierCompanyName); 
                    $('#add_supp #SupplierBRNo').val(res.data.SupplierBRNo);
                    $('#add_supp #SupplierName').val(res.data.SupplierName); 
                    $('#add_supp #SupplierNIC').val(res.data.SupplierNIC);
                    $('#add_supp #SupplierAddressLine1').val(res.data.SupplierAddressLine1);
                    $('#add_supp #SupplierAddressLine2').val(res.data.SupplierAddresLine2);
                    $('#add_supp #payment_term').val(res.data.payment_term);
                    $('#add_supp #SupplierCity   ').val(res.data.SupplierCity);
                    $('#add_supp #SupplierProvince').val(res.data.SupplierProvince);
                    $('#add_supp #SupplierCountry').val(res.data.SupplierCountry);
                    $('#add_supp #SupplierContactNo').val(res.data.SupplierContactNo);
                    $('#add_supp #SupplierEmail').val(res.data.SupplierEmail);
                    $('#add_supp #SupplierDescription').val(res.data.SupplierDescription);
                    $('#add_supp #SupplierBankName').val(res.data.SupplierBankName);
                    $('#add_supp #SupplierBankACNo   ').val(res.data.SupplierBankACNo);
                    $('#add_supp #SupplierID   ').val(res.data.SupplierID);
                    $('#add_supp #design  ').attr('src','/uploads/supImg/'+ res.data.SupplierImg);
                },
                    error: function (data) {
                        console.log(data);
                }
            });
        });
       //delete supplier
        $('body').on('click', '#suppdelete', function () 
        {
                var id = $(this).attr('data-id');
                swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                }).then((result) => {
                if (result.isConfirmed) {
                    $.get('supplier_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                    swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                  
                      })
                }
            });          
        });
          //supplier disable
          $('body').on('change', '#disable', function () 
        {
            var id = $(this).attr('data-id');
            //  alert(id);
            $.getJSON('disable_supplier/'+id, function (data) {                
              location.reload();
                    })
        });
        //supplier enable
        $('body').on('change', '#enable', function () 
        {
            var id = $(this).attr('data-id');
            $.getJSON('enable_supplier/'+id, function (data) {
                location.reload();
            })
        });
          //reset form
        $('#supplierModal').on('hidden.bs.modal', function (e)
         {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
        });
            // prevent multi submit
        document.querySelector('form').addEventListener('submit', function()
         {
            document.querySelector('#submit').disabled = true;
        });
    </script>

<?php $this->endSection() ?>