<?php $this->extend('layouts/master') ?>

<?php $this->section('employees') ?>

    <!---List of Employees --->
    <div class="container-fluid mt-3 list-of-customer">
        <div class="row p-2">
            <div class="col-12">
                <div class="row">
                    <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                        <div class="d-flex bd-highlight">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <!-- <div class="flex-fill bd-highlight">Delete</div> -->
                                        <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                <i class="bi bi-trash3-fill"></i>
                                            </button>
                                        </div>
                                        <!-- <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">Email</div> -->
                                        <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                <i class="bi bi-envelope-fill"></i>
                                            </button>
                                        </div>
                                        <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                            <!-- <button class="btn linear-bg text-secondary px-2 py-0" type="button"><i class="bi bi-search"></i></button> -->
                                            <div class="searchbar linear-bg">
                                                <input class="search_input" type="search" name="" placeholder="Search..." aria-controls="employees">
                                                <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <!-- <div class="flex-fill bd-highlight">New Customer</div> -->
                                        <div class="flex-fill bd-highlight">
                                            <div class="ms-1 me-1 py-0 text-primary fw-bold">
                                                <a class="btn linear-bg text-secondary px-2 py-0" href="/functionality">Functionalities </a>
                                                <a class="btn linear-bg text-secondary px-2 py-0" href="/user_detail">User </a>
                                                <a class="btn linear-bg text-secondary px-2 py-0" href="/userroles">User Roles</a>
                                                <a class="btn linear-bg text-secondary px-2 py-0" href="/userpermissions">User Permissions</a>
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="newemployee" data-bs-toggle="modal" data-bs-target="#employeemodel">New Employee <i class="bi bi-plus-lg fw-bold"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                            <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                <input hidden type="text" id="userchecked" name="userchecked" value="<?php echo $userchecked ;?>">
                                <table class="table rounded align-middle rounded" id="viewtable">
                                    <thead class=" text-center text-secondary rounded">
                                        <!-- <th class="rounded-start p-2" scope="col">
                                            <span class="all-select-check-box-col rounded">
                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                            </span>
                                        </th> -->
                                        <th class="p-2" scope="col">Name</th>
                                        <th class="p-2" scope="col">Designation</th>
                                        <th class="p-2" scope="col">E-mail</th>
                                        <th class="p-2" scope="col">Phone Number</th>
                                        <th class="p-2" scope="col">Status</th>
                                        <th class="p-2 rounded-end" scope="col">Edit</th>
                                    </thead>
                                    <tbody class="text-primary text-center fw-bold">                                     
                                        <?php 
                                            if($sources):
                                            foreach($sources as $source): 
                                            foreach($source as $s): 
                                        ?>
                                        <tr id="<?php echo $s['EmpID']; ?>">
                                            <!-- <th scope="row">
                                            </th> -->
                                            <td><?php echo $s['EmpName']; ?></td>
                                            <td><?php echo $s['EmpDesignation']; ?></td>
                                            <td><?php echo $s['EmpEmail']; ?></td>
                                            <td><?php echo $s['EmpContactNo']; ?></td>
                                            <?php 
                                                if($s['EmpID']=='1'){
                                                    ?>
                                                    <td></td>
                                                    <?php }
                                                else{
                                                    ?>
                                                    <td>
                                                        <?php 
                                                                if($s['current_status'] == '1'):
                                                            ?>
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['EmpID']; ?>" checked/>
                                                                </div>
                                                            <?php
                                                                else:
                                                            ?>
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['EmpID']; ?>" />
                                                                </div>
                                                            <?php
                                                                endif;
                                                            ?>
                                                    </td>
                                                    
                                                <?php
                                                      }?> 
                                            <?php 
                                            if($s['EmpID']=='1'){
                                           ?>
                                           <td>
                                           </td>
                                           <?php }
                                            else{
                                           ?>
                                            <td>
                                                <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" data-bs-toggle="modal" data-bs-target="#employeeUpdate" data-id="<?php echo $s['EmpID']; ?>" id="employeeEdit">
                                                    <i class="bi bi-pen-fill"></i>
                                                </button>
                                                <button class="btn linear-bg text-secondary px-2 py-0" id="empDelete" type="button" data-id="<?php echo $s['EmpID']; ?>">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        <?php
                                            }
                                            endforeach;
                                            endforeach;
                                            endif;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>       
    
    <div class="modal fade with-img-upload" id="employeemodel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header linear-bg">
                    <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> Employees Detail Form</h5>
                    <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form class="newEnpForm" id="EmployeesSignUpForm" action="/employee_save" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                        <div class="form-header d-flex mb-2">
                            <span class="stepIndicator text-center">Basic Information</span>                                        
                        </div>                                    
                        <div class="row">
                            <input type="hidden" class="form-control mb-3" name="EID" value="<?php echo set_value('EID');?>" id="EID" hidden>
                            <div class="mb-3 col">
                                <label for="name" class="col-form-label">Employee Name:</label>
                                <input type="text" class="form-control" id="EmpName" value="<?php echo set_value('EmpName');?>" name="EmpName" placeholder="Enter Name">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpName') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">
                                <label for="designation" class="col-form-label">Employee Designation:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpDesignation');?>" id="EmpDesignation" name="EmpDesignation" placeholder="Enter Designation">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpDesignation') : '' ?></h6>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="e-mail" class="col-form-label">Email:</label>
                                <input type="email" class="form-control" value="<?php echo set_value('EmpEmail');?>" id="EmpEmail" name="EmpEmail" placeholder="Enter Email" >
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpEmail') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">
                                <label for="Phone-number" class="col-form-label">Phone Number:</label>
                                <input type="tel" class="form-control phone_number" value="<?php echo set_value('EmpContactNo');?>" id="EmpContactNo" name="EmpContactNo" >
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpContactNo') : '' ?></h6>
                            </div>
                        </div>                                        
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="e-mail" class="col-form-label">DOB:</label>
                                <input class="form-control" max="<?php echo date("Y-m-d"); ?>" value="<?php echo set_value('EmpDateofBirth');?>" id="EmpDateofBirth" name="EmpDateofBirth" placeholder="MM/DD/YYY" type="date">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpDateofBirth') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">            
                                <label for="e-mail" class="col-form-label">Contact Person;</label>                        
                                <input type="text" value="<?php echo set_value('EmpAltContactPerson');?>" class="form-control" id="EmpAltContactPerson" name="EmpAltContactPerson" placeholder="Add contact person">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="Address1" class="col-form-label">Address 1:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpAddressLine1');?>" id="EmpAddressLine1" name="EmpAddressLine1" placeholder="Enter Address 1">
                            </div>
                            <div class="mb-3 col">
                                <label for="Address1" class="col-form-label">Address 2:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpAddressLine2');?>" id="EmpAddressLine2" name="EmpAddressLine2" placeholder="Enter Address 2">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="City" class="col-form-label">City:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpCity');?>" id="EmpCity" name="EmpCity" placeholder="Enter City">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpCity') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">
                                <label for="zip" class="col-form-label">Zip:</label>
                                <input type="text" class="form-control disableletter" value="<?php echo set_value('EmpProvince');?>"id="EmpProvince" name="EmpProvince" placeholder="Enter Province">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpProvince') : '' ?></h6>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="country" class="col-form-label">Country:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpCountry');?>" id="EmpCountry" name="EmpCountry" placeholder="Enter Country">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpCountry') : '' ?></h6>
                            </div>
                            <div class="mb-3 col">
                                <label for="Account-number" class="col-form-label">Employee NIC:</label>
                                <input type="text" class="form-control" value="<?php echo set_value('EmpNICNo');?>" id="EmpNICNo" name="EmpNICNo" placeholder="Add NIC">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'EmpNICNo') : '' ?></h6>
                            </div>
                        </div>
                        <!-- <div class="row">
                            <div class="mb-3 col">
                                <label for="e-mail" class="col-form-label">Employee Alternate NIC:</label>
                                <input type="text" class="form-control nicno" id="EmpAltNICNo" name="EmpAltNICNo" placeholder="Add alternative NIC">
                            </div>
                            <div class="mb-3 col">
                                <label for="e-mail" class="col-form-label">Employee Alternate Contact:</label>
                                <input type="text" class="form-control alt_phone_number" id="EmpAltContactNo" name="EmpAltContactNo" placeholder="Add alternative contact number">
                            </div>
                        </div> -->
                        <div class="row">
                            <div class="wrapper col">
                                <div class="box">
                                    <div class="js--image-preview">
                                        <img id="design" class="" alt="Ad Picture" style="width:auto; height:100px;"/>
                                    </div>
                                    <div class="upload-options">
                                        <label>
                                            <input type="file" value="<?php echo set_value('EmpImg');?>" class="image_upload" accept="image/*" name="EmpImg" id="EmpImg">
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3 col">                              
                                <div class="form-check checkbox-lg col mt-3 text-primary fw-bold d-flex ">
                                    <input class="form-check-input1 align-items-end" onclick="usercheckFunction()" type="checkbox" value="" name="usercheck" id="usercheck">
                                    <label class="form-check-label1 ms-1 align-items-end" for="flexCheckDefault1" id="system_user">
                                        : System User
                                    </label>
                                </div> 
                            </div>
                        </div>
                        <div class="loginfo" id="logInformation" style="display:none">
                            <input type="hidden" class="form-control" id="EmpId" value="<?php echo set_value('EmpId');?>" name="EmpId" placeholder="Add EmpId" >  
                            <div class="form-header d-flex mb-2">
                                <span class="stepIndicator text-center">Login Info</span>
                            </div>
                            <div class="mb-3">
                                <input type="hidden" class="form-control" id="Userchecked" name="Userchecked" >
                                <label for="uname" class="col-form-label">UserName:</label>
                                <input type="text" name="username" class="form-control" id="username" value="<?php echo set_value('username');?>" placeholder="Enter Username">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'username') : '' ?></h6>
                            </div>
                            <div class="mb-3">
                                <label for="uname" class="col-form-label">Password:</label>
                                <input type="Password" name="password" class="form-control" id="password" value="<?php echo set_value('password');?>" placeholder="Enter Password">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'password') : '' ?></h6>
                            </div>
                            <div class="mb-3">
                                <label for="cpassword" class="col-form-label">Confirm Password:</label>
                                <input type="Password" name="cPassword" class="form-control" id="cPassword" value="<?php echo set_value('cPassword');?>" placeholder="Enter Password Again">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'cPassword') : '' ?></h6>
                            </div>
                            <div class="mb-3" id="authdev" style="display:none">
                                <label id="authlabel" for="authkey" class="col-form-label">AuthKey:</label>
                                <input type="number" name="authkey" class="form-control" id="authkey" value="<?php echo set_value('authkey');?>" placeholder="Enter Authkey" >
                                <!-- <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'authkey') : '' ?></h6> -->
                            </div>
                            <label for="role" class="col-form-label">User Role:</label>
                            <input type="hidden" class="form-control" value="<?php echo set_value('UserID');?>" id="UserID" name="UserID" >
                            <div class="mb-3 col">
                                <!-- <input type="dropdown" class="form-control" name="RoleID" id="RoleID" placeholder="Enter User Role"> -->
                                <select class="form-control" name="RoleID" id="RoleID">
                                    <option value="">Please Select a user role</option> 
                                    <?php                                        
                                            if($userroles):
                                            foreach($userroles as $userrole): 
                                            foreach($userrole as $ur):
                                        ?>                                        
                                        <option value="<?php echo $ur['URoleID']; ?>" <?php echo set_value('RoleID') ==  $ur['URoleID'] ? 'selected' : ''; ?>><?php echo $ur['URName']; ?></option>
                                        <?php
                                            endforeach;
                                            endforeach;
                                            endif;
                                        ?>
                                </select>
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'RoleID') : '' ?></h6>
                            </div>                     
                        </div>  
                        <div class="modal-footer ">
                            <div class="d-flex align-items-start"> 
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitBtn">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!--- List of Employees End --->
    <?php echo view('includes/footer'); ?>

    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) 
        {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openEmpModal()
        {
            var emp_modal = $("#employeemodel");
            var has_errors = $("#has_errors").val();
            var userchecked=$("#userchecked").val();
           
            if(has_errors == 'true'){
                emp_modal.modal('show');
                if(userchecked=='1'){
                    // const nowInSeconds = Math.floor(Date.now() / 1000);
                    $("#usercheck").prop('checked', true);
                    $('#employeemodel #logInformation  #Userchecked').val(1);
                    // $('#employeemodel #logInformation #authkey').val(nowInSeconds);
                    $('#employeemodel #logInformation').show();
                 

                }
            }
        }
        $(document).ready(function() 
        {
            openEmpModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            URTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                URTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    URTable.rows().select();        
                } else {
                    URTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        // user check element 
        $('body').on('click', '#newemployee', function () 
        {
                // alert('hi');
                $('#employeemodel #logInformation').hide();
        });
        // update employe
        $('body').on('click', '#employeeEdit', function () 
        {
            var EmpID = $(this).attr('data-id');
            $.ajax({
                url: 'employees_edit/'+EmpID,
                type: "GET",
                dataType: 'json',
                success: function (res) { //only employee details
                    $('#employeemodel').modal('show');
                    console.log(res.data)
                    $('#EmployeesSignUpForm #EID').val(res.data.EmpID); 
                    $('#EmployeesSignUpForm #EmpName').val(res.data.EmpName); 
                    $('#EmployeesSignUpForm #EmpDesignation').val(res.data.EmpDesignation);
                    $('#EmployeesSignUpForm #EmpEmail').val(res.data.EmpEmail); 
                    $('#EmployeesSignUpForm #EmpContactNo').val(res.data.EmpContactNo);
                    $('#EmployeesSignUpForm #EmpDateofBirth').val(res.data.EmpDateofBirth);
                    $('#EmployeesSignUpForm #EmpAltContactPerson').val(res.data.EmpAltContactPerson);
                    $('#EmployeesSignUpForm #EmpAddressLine1   ').val(res.data.EmpAddressLine1);
                    $('#EmployeesSignUpForm #EmpAddressLine2').val(res.data.EmpAddressLine2);
                    $('#EmployeesSignUpForm #EmpAddressLine2').val(res.data.EmpAddressLine2);
                    $('#EmployeesSignUpForm #EmpCity').val(res.data.EmpCity);
                    $('#EmployeesSignUpForm #EmpProvince').val(res.data.EmpProvince);
                    $('#EmployeesSignUpForm #EmpCountry').val(res.data.EmpCountry);
                    $('#EmployeesSignUpForm #EmpNICNo').val(res.data.EmpNICNo);
                    $('#EmployeesSignUpForm #EmpAltNICNo').val(res.data.EmpAltNICNo);
                    $('#EmployeesSignUpForm #EmpAltContactNo').val(res.data.EmpAltContactNo);
                    $('#EmployeesSignUpForm #EmpAltNICNo').val(res.data.EmpAltNICNo);
                    $('#EmployeesSignUpForm #EmpId').val(res.data.EmpID);
                    $('#EmployeesSignUpForm #design').attr('src','/uploads/empImg/'+ res.data.EmpImg);
                    $('#EmployeesSignUpForm #usercheck').prop('disabled', false);
                    if(res.data.UserID ){   //when employee register as user
                         console.log('data');
                         $('#EmployeesSignUpForm #EID').val(res.data.EmpID); 
                         $('#EmployeesSignUpForm #EmpName').val(res.data.EmpName); 
                         $('#EmployeesSignUpForm #EmpDesignation').val(res.data.EmpDesignation);
                         $('#EmployeesSignUpForm #EmpEmail').val(res.data.EmpEmail); 
                         $('#EmployeesSignUpForm #EmpContactNo').val(res.data.EmpContactNo);
                         $('#EmployeesSignUpForm #EmpDateofBirth').val(res.data.EmpDateofBirth);
                         $('#EmployeesSignUpForm #EmpAltContactPerson').val(res.data.EmpAltContactPerson);
                         $('#EmployeesSignUpForm #EmpAddressLine1   ').val(res.data.EmpAddressLine1);
                         $('#EmployeesSignUpForm #EmpAddressLine2').val(res.data.EmpAddressLine2);
                         $('#EmployeesSignUpForm #EmpAddressLine2').val(res.data.EmpAddressLine2);
                         $('#EmployeesSignUpForm #EmpCity').val(res.data.EmpCity);
                         $('#EmployeesSignUpForm #EmpProvince').val(res.data.EmpProvince);
                         $('#EmployeesSignUpForm #EmpCountry').val(res.data.EmpCountry);
                         $('#EmployeesSignUpForm #EmpNICNo').val(res.data.EmpNICNo);
                         $('#EmployeesSignUpForm #EmpAltNICNo').val(res.data.EmpAltNICNo);
                         $('#EmployeesSignUpForm #EmpAltContactNo').val(res.data.EmpAltContactNo);
                         $('#EmployeesSignUpForm #EmpAltNICNo').val(res.data.EmpAltNICNo);
                         $('#EmployeesSignUpForm #EmpId').val(res.data.EmpID);
                         $('#EmployeesSignUpForm #design').attr('src','/uploads/empImg/'+ res.data.EmpImg);
                        if(res.data.delete_flag=='0')  //check userStatus is 0 or 1 ,if it is '1' user delete from system
                        {
                         $('#EmployeesSignUpForm #usercheck').prop( "checked", true );
                         $('#EmployeesSignUpForm #usercheck').prop('disabled', true);
                         $('#EmployeesSignUpForm #usercheck').val(res.data.UserID);
                         $('#EmployeesSignUpForm #logInformation').show();                       
                         $('#EmployeesSignUpForm #usercheck').css("display","block");
                         $('label[for="flexCheckDefault"]').show();
                         $('#EmployeesSignUpForm #Userchecked').val('1');
                         $('#EmployeesSignUpForm #username').val(res.data.UserName);
                         $('#EmployeesSignUpForm #EmpId').val(res.data.EmpID);
                         $('#EmployeesSignUpForm #password').val(res.data.UserPassword);
                         $('#EmployeesSignUpForm #cPassword ').val(res.data.UserPassword);
                         $('#EmployeesSignUpForm #authkey ').val(res.data.AuthKey);
                        //  $('#EmployeesSignUpForm #authkey ').hide();
                        //  $('#EmployeesSignUpForm #authlabel ').hide();
                        
                         if(res.data.UserName=='manager'){
                            // alert(res.data.UserRole);
                            // $('#EmployeesSignUpForm #authkey ').show();
                            // $('#EmployeesSignUpForm #authlabel ').show();
                            // $('#EmployeesSignUpForm #authkey ').prop("readonly", false);
                            $('#EmployeesSignUpForm #authdev').show();
                         }
                         else{
                            $('#EmployeesSignUpForm #authdev').hide();
                         }
                        }
                        else{
                            $('#EmployeesSignUpForm #usercheck').hide(); 
                            $('#EmployeesSignUpForm #system_user').hide();  
                            $('#EmployeesSignUpForm #logInformation').hide();    
                            $('#EmployeesSignUpForm #Username').val("");
                            // $("#EmployeesSignUpForm #Username").prop('required',true);
                            $('#EmployeesSignUpForm #Password').val("");
                            // $("#EmployeesSignUpForm #Password").prop('required',true);
                            $('#EmployeesSignUpForm #cPassword   ').val("");
                            // $("#EmployeesSignUpForm #cPassword").prop('required',true);
                            $('#EmployeesSignUpForm #authkey').val("");
                            $('#EmployeesSignUpForm #RoleID').val("");
                            var modal = $('#employeemodel');
                            modal.hide();
                            }


                            $('#EmployeesSignUpForm #RoleID').val(res.data.UserRole);
                            $('#EmployeesSignUpForm #UserID').val(res.data.UserID);                       
                        }
                    else{
                            console.log('checked');
                            $('#EmployeesSignUpForm #logInformation').hide();    
                            $('#EmployeesSignUpForm #Username').val("");
                            // $("#EmployeesSignUpForm #Username").prop('required',true);
                            $('#EmployeesSignUpForm #Password').val("");
                            // $("#EmployeesSignUpForm #Password").prop('required',true);
                            $('#EmployeesSignUpForm #cPassword   ').val("");
                            // $("#EmployeesSignUpForm #cPassword").prop('required',true);
                            $('#EmployeesSignUpForm #authkey').val("");
                            $('#EmployeesSignUpForm #RoleID').val("");
                            // $("#EmployeesSignUpForm #RoleID").prop('required',true);
                        }
                },
                    error: function (data) {
                        console.log(data);
                }
            });
        });
        //delete employee
        $('body').on('click', '#empDelete', function ()
         {
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.get('employees_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                      })
                }
             });

                    
        });

    </script>
    <script>
        function usercheckFunction()
        {
            if ($('#usercheck').prop('checked')) {
                const nowInSeconds = Math.floor(Date.now() / 1000);
                $('#employeemodel #logInformation').show();
                $('#employeemodel #logInformation  #Userchecked').val(1);
                $('#employeemodel #logInformation #authkey').val(nowInSeconds);
                $("#employeemodel #logInformation #authkey").prop("readonly", true);
                
            }
            else{
                $('#employeemodel #logInformation').hide();
                var id = $('#EmployeesSignUpForm #usercheck').val();
                // alert(id);
            //     swal.fire({
		  	//     title: 'Are you sure?',
		  	//     text: "You won't be able to revert this!",
		  	//     icon: 'warning',
		  	//     showCancelButton: true,
		  	//     confirmButtonText: 'Yes, delete it!',
		    // }).then((result) => {
            //     if (result.isConfirmed) {
            //         $.get('user_delete/'+id, function (data) {
            //     if(data.error)
            //         // alert('Can not delete, this record has related information');    
            //         swal.fire({
            //             title: 'Can not delete',
            //             text: "This record has related information",
            //             icon: 'warning',
            //             showCancelButton: false,
            //             confirmButtonText: 'OK',
                        
		    //         });
            //     else
            //     swal.fire({
            //             title: 'Deleted',
            //             text: "This record has deleted Successfully!",
            //             icon: 'success',
            //             showCancelButton: false,
            //             confirmButtonText: 'OK',                       
            //         }).then((result) => {
            //             location.reload();
            //             $('#viewtable tbody #'+ id).remove();
            //             // var modal = $('#employeemodel');
            //             //     modal.hide();
            //         });
            //           })
            //     }
            //  });
                
            }
        }
        function submitForm(e)
        {
            e.preventDefault();
            document.getElementById("EmployeesSignUpForm").submit();
            return false;
        }
    </script>
    <script>
        function initImageUpload(box) 
        {
            let uploadField = box.querySelector('.image_upload');
            uploadField.addEventListener('change', getFile);
            function getFile(e) {
                let file = e.currentTarget.files[0];
                checkType(file);
            }
            function previewImage(file) {
                let thumb = box.querySelector('.js--image-preview'),
                    reader = new FileReader();
                    reader.onload = function () {
                    thumb.style.backgroundImage = 'url(' + reader.result + ')';
                }
                reader.readAsDataURL(file);
                thumb.className += ' js--no-default';
            }
            function checkType(file) {
                let imageType = /image.*/;
                if (!file.type.match(imageType)) {
                    throw 'Datei ist kein Bild';
                } else if (!file) {
                    throw 'Kein Bild gewählt';
                } else {
                    previewImage(file);
                }
            }
        }
        // initialize box-scope
        var boxes = document.querySelectorAll('.box');
        for (let i = 0; i < boxes.length; i++) 
        {
            let box = boxes[i];
            initDropEffect(box);
            initImageUpload(box);
        }
        /// drop-effect
        function initDropEffect(box) 
        {
            let area, drop, areaWidth, areaHeight, maxDistance, dropWidth, dropHeight, x, y;

            // get clickable area for drop effect
            area = box.querySelector('.js--image-preview');
            area.addEventListener('click', fireRipple);
            
            function fireRipple(e) {
                area = e.currentTarget
                // create drop
                if (!drop) {
                    drop = document.createElement('span');
                    drop.className = 'drop';
                    this.appendChild(drop);
                }
                // reset animate class
                drop.className = 'drop';
                // calculate dimensions of area (longest side)
                areaWidth = getComputedStyle(this, null).getPropertyValue("width");
                areaHeight = getComputedStyle(this, null).getPropertyValue("height");
                maxDistance = Math.max(parseInt(areaWidth, 10), parseInt(areaHeight, 10));
                // set drop dimensions to fill area
                drop.style.width = maxDistance + 'px';
                drop.style.height = maxDistance + 'px';
                // calculate dimensions of drop
                dropWidth = getComputedStyle(this, null).getPropertyValue("width");
                dropHeight = getComputedStyle(this, null).getPropertyValue("height");
                // calculate relative coordinates of click
                // logic: click coordinates relative to page - parent's position relative to page - half of self height/width to make it controllable from the center
                x = e.pageX - this.offsetLeft - (parseInt(dropWidth, 10) / 2);
                y = e.pageY - this.offsetTop - (parseInt(dropHeight, 10) / 2) - 30;
                // position drop and animate
                drop.style.top = y + 'px';
                drop.style.left = x + 'px';
                drop.className += ' animate';
                e.stopPropagation();
            }
        }
         //employee disable
         $('body').on('change', '#disable', function () 
        {
                    var id = $(this).attr('data-id');
                    // alert(id);
                    $.getJSON('disable_employee/'+id, function (data) {                
                        location.reload();
                        // if(data['status'] == 'true'){
                        //     $(this).is(":not(:checked)");
                        // }
                    })
        }); 
        //employee enable
        $('body').on('change', '#enable', function () 
        {
            var id = $(this).attr('data-id');
            
            $.getJSON('enable_employee/'+id, function (data) {
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":checked");
                // }
            })
        });
        //reset form
        $('#employeemodel').on('hidden.bs.modal', function (e)
        {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
        //  prevent multi submit
         document.querySelector('form').addEventListener('submit', function()
          {
            document.querySelector('#submitBtn').disabled = true;
          });
                  
    </script>

<?php $this->endSection() ?>