<?php
namespace App\Models;

use CodeIgniter\Model;

class ReceivingDetailModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'receivingdetails';
    protected $primaryKey       = 'RDID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['RDID','RID','ItemID','RDIsSerialized','RDLine','RDQty','RDCostPrice', 'RDSellingPrice', 'RDiscount', 'RAmount','RDCreatedAt','RDUpdatedAt','RDDeletedAt','RDStatus','RDCreatedBy','RDUpdatedBy','RDDeletedBy'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];    

    function insertRecDetailData33($finalTabledata)
    {
        echo '<pre>';
        print_r($finalTabledata);
        die();
    }

    function saveData($finalTabledata)
    {
        $db = db_connect();
        $builder = $db->table($this->table);

        $builder->insert($finalTabledata);

        return $db->insertID();
    }

    function getSerialData($last_id)
    {
        return $this->db
            ->table('receivingdetails')
            ->where(["RDIsSerialized " => '1'])
            ->get()
            ->getRow();

    }

    function getSingleRecDetailData($id)
    {
        return $this->db
            ->table('receivingdetails')
            ->where(["RID " => $id])
                ->join('item', 'item.ItemID = receivingdetails.ItemID')
                ->join('units', 'units.UnitID = receivingdetails.RDUnit')
            ->get()
            ->getResultArray();
    }

    
    function getSingleRecDetailDataForSellingPrice($id)
    {
        return $this->db
            ->table('receivingdetails')
            ->where(["RDID " => $id])
            ->where(["RDStatus " => '1'])
            ->get()
            ->getResultArray();
    }

    function getSellingPriceData()
    {
        return $this->db
            ->select('*')
            ->table('receivingdetails')
            ->where(["RDStatus " => '1'])
            // ->join('receiving','receiving.RID= receivingdetails.RID')
            // ->join('item','item.ItemID= receivingdetails.ItemID')
            ->get()
            ->getRow();

    }

       // update RecevingDetailData
       function updateRecevingDetailData($id,$data)
       {
           return $this->db
               ->table('receivingdetails')
               ->where(["RDID" => $id])
               ->set($data)
               ->update();

       }

       // save receiving detail  data
    function insertRecevingDetailData($data)
	{
        return $this->db
        ->table('receivingdetails')
        ->insert($data);
	}
    function getPriceDetails(){
        return $this->db->table('receivingdetails')->where(["RDStatus " => '1'])
            ->join('receiving','receiving.RID= receivingdetails.RID')
            ->join('item','item.ItemID= receivingdetails.ItemID')
            ->join('units','units.UnitID= item.ItemUnit')
            ->select('receiving.*,receivingdetails.*,item.*,units.UnitID,units.UnitName')
            ->get()
            ->getResultArray();
    }
}
