<?php

namespace App\Models;

use CodeIgniter\Model;

class EmployeeModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'employee';
    protected $primaryKey       = 'EmpID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['EmpID', 'EmpImg', 'EmpName', 'EmpDesignation', 'EmpDateofBirth', 'EmpNICNo', 'EmpAddressLine1', 'EmpAddressLine2', 'EmpCity', 'EmpProvince', 'EmpCountry', 'EmpContactNo', 'EmpEmail', 'EmpAltContactPerson', 'EmpAltNICNo', 'EmpAltContactNo', 'EmpCreatedAt','EmpCreatedBy', 'EmpUpdatedAt','EmpUpdatedBy', 'EmpDeletedAt', 'EmpDeletedBy','current_status','delete_flag'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'EmpCreatedAt';
    protected $updatedField  = 'EmpUpdatedAt';
    protected $deletedField  = 'EmpDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    // save employee data
    function insertEmpData($data)
	{    
        return $this->db
            ->table('employee')
            ->insert($data);
	}
    // get index data
    function getIndexData()
    {
        $data= $this->db
            ->table('employee')
            ->where('delete_flag', '0')
            ->orWhere('current_status', '1')
            ->orderBy('EmpID ', 'ASC')
            ->get()
            ->getResultArray();
           return $data;
    }
    // get signle employee data
    function getSingleEmpData($id)
    {
        return $this->db
            ->table('employee')
            // ->join('employee', 'employee.EmpID= user.EmpID','inner')
            ->where(["EmpID" => $id])
            ->get()
            ->getRow();
    }
    // update employee
    function updateEmp($data,$id)
    {
        return $this->db
            ->table('employee')
            ->where(["EmpID" => $id])
            ->set($data)
            ->update();
    }
    // delete employee
    function deleteEmp($id,$data)
    {
        return $this->db
            ->table('employee')
            ->where(["EmpID" => $id])
            ->set($data)
            ->update();
    }
    function getUserEmployeeJoinData($id)
    {
        return $this->db
            ->table('employee')
            ->where("employee.EmpID", $id)
            ->join('user','user.EmpID= employee.EmpID')
            ->get()
            ->getRow();   
    }
     // user status  change
     function statusupdate($id,$data)
     {
         return $this->db
             ->table('employee')
             ->where(["EmpID" => $id])
             ->set($data)
             ->update();
     }


}
