<?php

namespace App\Models;

use CodeIgniter\Model;

class DiscountTypeModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'discount_types';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['discount_type', 'created_at', 'updated_at', 'deleted_at', 'delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    // get all discount type  data
    function getIndexDiscountData()
    {
        $data= $this->db
        ->table('discount_types')
        ->where('delete_flag', '0')
        ->orderBy('id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }
    // save discount type  data
    function insertData($data)
	{
        return $this->db
        ->table('discount_types')
        ->insert($data);
	}
    // get single discount type  data
    function getSingleDiscData($id)
    {
        return $this->db
             ->table('discount_types')
             ->where(["id" => $id])
             ->get()
             ->getRow();
    }
    // update discount type 
    function updateData($id,$data)
    {
        return $this->db
        ->table('discount_types')
        ->where(["id" => $id])
        ->set($data)
        ->update();
    }
    // delete discount type 
    function deleteData($id,$data)
    {
        // print_r($data);
        // die();
        return $this->db
        ->table('discount_types')
        ->where(["id" => $id])
        ->set($data)
        ->update();

    }
      //  status  change
    function statusupdate($id,$data)
    {
        return $this->db
            ->table('discount_types')
            ->where(["id" => $id])
            ->set($data)
            ->update();
    }
}
