<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class SellingPrice extends Migration
{
    public function up()
    {
          //Create selling price Table
          $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'item_id' => [
                'type' => 'INT',
            ],
            'item_name'=> [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'selling_price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'batch_number' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'comment' => [
                'type' => 'TEXT',
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('selling_price');
    }

    public function down()
    {
         //update selling_price Table
         $this->forge->dropTable('selling_price');
    }
}
