<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemSerialized extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'RefID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RDID' => [
                'type' => 'INT',
            ],
            'RefSerialNos' => [
                'type' => 'INT',
            ],
            'RefStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('RefID');
        $this->forge->createTable('itemserialized');
    }

    public function down()
    {
        //
        $this->forge->dropTable('itemserialized');
    }
}
