<?php

    namespace App\Controllers;
    use App\Models\UserModel;
    use App\Models\CommonModel;
    class UserController extends BaseController
    {
            public function __construct()
            {
                $this->userModel = new UserModel();   
                $this->common = new CommonModel(); 
                helper(['url','form','app']);
            }      
            public function ModifySaleCheckAuthorization($auth_key)
            {
                $authoriz_data =  $this->userModel->ModifySaleCheckAuthorization($auth_key);
                return $this->response->setJSON([
                    'error' => false,
                    'is_authorized' => $authoriz_data['is_authorized'],
                    'authorized_by' => $authoriz_data['authorized_by']
                ]);
            }
            public function index()
            {
                $user_info = getUserInfo();
                $user['user']= $this->userModel->getUserData();                
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'User ',
                    'link' => 'user_detail',
                    'sources' => $user,
                    'userinfo' => $user_info,
                );
                return view('user', $data);
            }
            public function delete($id = null)
            {
            
                $user_info = getUserInfo();   
                $has_sales_info = $this->common->checkForeignKeyConstraints("sales","user_id",$id,"delete_flag",0);
                $has_rulebook_info = $this->common->checkForeignKeyConstraints("rulebook","UserID",$id,"delete_flag",0);
                $has_receiving_info = $this->common->checkForeignKeyConstraints("receiving","UserID",$id,"RStatus",1);
                $has_payments_info = $this->common->checkForeignKeyConstraints("payments","payment_authorized_by_id",$id,"delete_flag",0);
                $has_postracking_info = $this->common->checkForeignKeyConstraints("postracking","UserID",$id,"PTStatus",1);
                $has_gift_cards_info = $this->common->checkForeignKeyConstraints("gift_cards","giftcard_issued_by",$id,"delete_flag",0);
                $has_temp_receiving_info = $this->common->checkForeignKeyConstraints("temp_receiving","UserID",$id,"RStatus",1);
                $now = date("Y-m-d H:i:s");
                $data = [
                    'UserDeletedAt' => $now,
                    'UserDeletedBy'=>$user_info->UserID,
                    'delete_flag' => '1',
                ];
                //define message
                $msg_prefix = 'This user has ';
                $msg_rulebook_info = ' rulebook information ';
                $msg_receiving_info = 'receiving information';
                $msg = '';
                if($has_rulebook_info){
                    if($has_receiving_info){
                        $msg = $msg_prefix.$msg_receiving_info;
                    }
                    else{
                        $msg = $msg_prefix.$msg_rulebook_info;
                    }
                }
                if($has_rulebook_info || $has_receiving_info){
                    return $this->response->setJSON([
                        'error' => true,
                        'message' => $msg
                    ]);
                    }
                else{
                    $this->userModel->deleteUser($id, $data);
                    return $this->response->setJSON([
                        'error' => false,
                        'message' => 'Successfully deleted!'
                    ]);
                }
                
                // if($has_sales_info || $has_rulebook_info || $has_receiving_info||  $has_payments_info || $has_postracking_info|| $has_gift_cards_info|| $has_temp_receiving_info){
                // // if($has_sales_info){
                //     return $this->response->setJSON([
                //         'error' => true,
                //         'message' => 'Can not delete, this record has related information'
                //     ]);
                // }
        
                // $UserRoleModel->update($id, $data);
                // $this->userroleModel->deleteUrole($id, $data);
                // return $this->response->setJSON([
                //     'error' => false,
                //     'message' => 'Successfully deleted!'
                // ]);
                return $this->response->redirect(site_url('/items'));
            } 
           // user disable
           public function disableuser($id = null)
           {
               $data = [
                   'current_status' => '2'
               ];
   
               if($this->userModel->statusupdate($id, $data)):                
                   echo json_encode(array('status'=>true));
               endif;
           }
           // user enable
           public function enableuser($id = null)
           {
               $data = [
                   'current_status' => '1'
               ];
   
               if($this->userModel->statusupdate($id, $data)):                
                   echo json_encode(array('status'=>true));
               endif;
           }
    }
?>