<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\TerminalModel;
use App\Models\TenantModel;

class TerminalController extends BaseController
{
        //construct function
        public function __construct()
        {
            $this->terminal = new TerminalModel();     
            $this->tenants = new TenantModel();   
            $this->db = \Config\Database::connect();     
            helper(['url','form','app']);
        }
        //insert/update data
        public function submit()
        {
            $user_info = getUserInfo();
            $validation = $this->validate([
                'pos_id' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select POS ID',
                    ],
                ],
                'tenant_id' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select tenant ID',
                    ],
                ],
                'stall_no' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter stall number',
                    ],
                ],
                'location' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter location',
                    ],
                ],
            ]);
            $id = $this->request->getVar('id');
            $session = session();
            if($validation){
                if($id == ''){  
                    //insert
                    $data = [
                        'pos_id' => $this->request->getVar('pos_id'),
                        'tenant_id'  => $this->request->getVar('tenant_id'),
                        'stall_no'  => $this->request->getVar('stall_no'),
                        'location'  => $this->request->getVar('location'),
                        'created_at' => date('Y-m-d H:i:s'),
                        'created_by' =>  $user_info->UserID,
                        'delete_flag'=>0,
                    ];
                    //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();
                    $this->terminal->insertData($data);
                    if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                        // Set the success flash message
                        $session->setFlashdata('title', 'Error');
                        $session->setFlashdata('icon', 'warning');
                        $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                    // Set the success flash message
                        $session->setFlashdata('title', 'Saved');
                        $session->setFlashdata('icon', 'success');
                        $session->setFlashdata('message', 'Terminal details saved successfully.'); 
                    }           
                }
                else{   
                    //update
                    $data = [
                        'pos_id' => $this->request->getVar('pos_id'),
                        'tenant_id'  => $this->request->getVar('tenant_id'),
                        'stall_no'  => $this->request->getVar('stall_no'),
                        'location'  => $this->request->getVar('location'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'updated_by' =>  $user_info->UserID,
                    ];
                    $this->terminal->updateData($id, $data);
                    // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('message', 'Terminal details updated successfully.');
                }
                return $this->response->redirect(site_url('/terminal'));
            }
            else{
                $user_info = getUserInfo();
                $records['Terminals'] = $this->terminal->index();
                $has_errors = 'true';
                $tenants = $this->tenants->index();
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Terminals',
                    'link' => 'terminal',
                    'sources' => $records,
                    'userinfo' => $user_info,
                    'validation'=>$this->validator,
                    'has_errors' => $has_errors,
                    'tenants' => $tenants,
                );
                return view('/terminal', $data);
            }
        }
        //get specific data
        public function getSpecificData($id = null) 
        {
            $data=$this->terminal->getSpecificData($id);
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
        }
        //get all data
        public function index()
        {
            $user_info = getUserInfo();
            $records['Terminals'] = $this->terminal->index();
            $has_errors = 'false';
            $tenants = $this->tenants->indexActiveData();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Terminals',
                'link' => 'terminal',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'tenants' => $tenants,
            );
            return view('terminal', $data);
        }
        // delete data
        public function delete($id = null)
        {
            $user_info = getUserInfo();
            $data = [
                'deleted_at' => date("Y-m-d H:i:s"),
                'deleted_by' =>  $user_info->UserID,
                'delete_flag' => 1,
            ];
            $this->terminal->deleteData($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        } 
       // terminal disable
       public function disableterminbal($id = null)
       {
           $data = [
               'current_status' => '2'
           ];
           if($this->terminal->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
       // terminal enable
       public function enableterminal($id = null)
       {
           $data = [
               'current_status' => '1'
           ];
           if($this->terminal->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
       }
}
