<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\PrModel;
use App\Models\ItemsModel;
use App\Models\BanksModel;
use App\Controllers\BaseController;

class PriceRulesController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->pruleModel = new PrModel();
        $this->bankModel = new BanksModel();
        $this->now = date("Y-m-d H:i:s");
        $this->ItemsModel = new ItemsModel();
        helper(['url','form','app']);
    }

    
    // insert data
    public function submit()
     {
        echo '<pre>';
        print_r($this->request->getVar());
          die();
        $user_info = getUserInfo();
        $validation = $this->validate([
            'pr_type' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'pr_name' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter name',
                ],
            ],
            'pr_value' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
                
            ],
            'pr_items' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'pr_bank' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'pr_rate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'pr_started_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select date',
                ],
                
            ],
            'pr_end_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select date',
                ],
            ],

        ]);
        $prID = $this->request->getVar('pr_id');
        $session = session();
        if($validation){
            if($prID == ''){  //insert price rules details
        $data = [
            'pr_type' => $this->request->getVar('pr_type'),
            'pr_name'  => $this->request->getVar('pr_name'),
            'pr_value'  => $this->request->getVar('pr_value'),
            'pr_items'  => $this->request->getVar('pr_items'),
            'pr_bank'  => $this->request->getVar('pr_bank'),
            'pr_rate' => $this->request->getVar('pr_rate'),
            'pr_started_date'  => $this->request->getVar('pr_started_date'),
            'pr_end_date'  => $this->request->getVar('pr_end_date'),
            'pr_status' => '1',
            'pr_created_at' => date('Y-m-d H:i:s'),
            'created_by' =>  $user_info->UserID,
        ];
        $this->pruleModel->insertPriceRulesData($data);
          // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Price rule details saved successfully.');
        }
        else{   //update price rules details
            $data = [
                'pr_type' => $this->request->getVar('pr_type'),
                'pr_name'  => $this->request->getVar('pr_name'),
                'pr_value'  => $this->request->getVar('pr_value'),
                'pr_items'  => $this->request->getVar('pr_items'),
                'pr_bank'  => $this->request->getVar('pr_bank'),
                'pr_rate' => $this->request->getVar('pr_rate'),
                'pr_started_date'  => $this->request->getVar('pr_started_date'),
                'pr_end_date'  => $this->request->getVar('pr_end_date'),
                'pr_updated_at	'=>date('Y-m-d H:i:s'),
                'updated_by' =>  $user_info->UserID,
            ];
            $this->pruleModel->updatePriceRulesData($prID, $data);
              // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Price rule details updated successfully.');
        }
        return $this->response->redirect(site_url('/pricerules'));
        }
        else{
            $user_info = getUserInfo();
            $pr['Pricerules']=$this->pruleModel->getIndexpRuleData();
            $items = $this->ItemsModel->getItemIndexData();
            $banks=$this->bankModel->getIndexNBankData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Price Rules',
                'link' => 'pricerules',
                'sources' => $pr,
                'userinfo' => $user_info,
                'items'=>$items,
                'banks'=>$banks,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
            );
            return view('pricerules', $data);
        }
   
    }
    // get single data
    public function getSpecificData($id = null)
     {
        $data=$this->pruleModel->getSinglePruleData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $pr['Pricerules']=$this->pruleModel->getIndexpRuleData();
        $items = $this->ItemsModel->getItemIndexData();
        $banks=$this->bankModel->getIndexNBankData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Price Rules',
            'link' => 'pricerules',
            'sources' => $pr,
            'userinfo' => $user_info,
            'items'=>$items,
            'banks'=>$banks,
            'has_errors' => $has_errors,
        );
        return view('pricerules', $data);
    }
    
    // delete
    public function delete($id = null){
        $user_info = getUserInfo();
        $data = [
            'pr_deleted_at' =>  $this->now,
            'pr_status' => '0',
            'deleted_by' =>  $user_info->UserID,
        ];
        $this->pruleModel->deletePrule($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/pricerules'));
    } 
}
