<?php

namespace App\Models;

use CodeIgniter\Model;

class TerminalsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'terminals';
    protected $primaryKey       = 'TerID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['TerID', 'POSID', 'TanentID', 'StallNo', 'TerLocation', 'TerCreatedAt', 'TerUpdatedAt', 'TerDeletedAt', 'TerStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'TerCreatedAt';
    protected $updatedField  = 'TerUpdatedAt';
    protected $deletedField  = 'TerDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
