<?php

namespace App\Models;

use CodeIgniter\Model;

class TenantModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'tenant';
    protected $primaryKey       = 'TID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['TID', 'TName', 'TLogo', 'TBRNo', 'TAddress1', 'TAddress2', 'TCity', 'TProvince', 'TCountry', 'TOwnerName', 'TOwnerNIC', 'TCreatedAt', 'TUpdatedAt', 'TDeletedAt', 'TStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'TCreatedAt';
    protected $updatedField  = 'TUpdatedAt';
    protected $deletedField  = 'TDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    
      // save tenant register  data
      function insertTenData($data)
      {
        // echo '<pre>';
        // print_r($data);
        // die();
          return $this->db
                      ->table('tenant')
                      ->insert($data);
      }
      // get all data
      function index(){
        $data= $this->db->table('tenant')->where('TStatus', 1)->orderBy('TID', 'ASC')->get()->getResultArray();
        return $data;
      }

}
