<?php

namespace App\Models;

use CodeIgniter\Model;

class StocksModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'stocks';
    protected $primaryKey       = 'StockID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ItemID', 'BatchNO', 'Unit', 'Qty', 'Price', 'DelEstimatedShippingDate', 'ExpDate', 'StockCreatedAt', 'StockUpdatedAt', 'StockDeletedAt', 'StockStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'StockCreatedAt';
    protected $updatedField  = 'StockUpdatedAt';
    protected $deletedField  = 'StockDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all stock data    
    function getAllStocksData()
    {
        return $this->db
            ->table('stocks')
            ->where('StockStatus', '1')
            ->orderBy('StockID ', 'ASC')
            ->get()
            ->getResultArray();
    }

    // get single stock data
    function getSingleStockData($id)
    {
        return $this->db
            ->table('stocks')
            ->where(["StockID" => $id])
            ->get()
            ->getRow();
    }

    // check all stock data
    function checkAllStockData($id)
    {
        return $this->db
            ->table('stocks')
            ->where(["ItemID" => $id])
            ->get()
            ->getResultArray();
    }
}
