<?php

namespace App\Models;

use CodeIgniter\Model;

class ConversionFactorModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'conversionfactors';
    protected $primaryKey       = 'CFID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['FromUnitiD', 'ToUnitID', 'CFFactor', 'CFCreatedAt', 'CFUpdatedAt', 'CFDeletedAt', 'CFStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'CFCreatedAt';
    protected $updatedField  = 'CFUpdatedAt';
    protected $deletedField  = 'CFDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all CFs data    
    function getAllCFsData()
    {
        return $this->db
            ->table('conversionfactor')
            ->where('CFStatus', '1')
            ->orderBy('CFID ', 'ASC')
            ->get()
            ->getResultArray();
    }

    // save CFs data
    function insertCFs($data)
	{      
        return $this->db
            ->table('conversionfactor')
            ->insert($data);
	}
    
    // get single CF data
    function getSingleCFData($id)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->get()
            ->getRow();
    }

    // update Cfs data
    function updateCFs($id, $data)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->set($data)
            ->update();
    }

    // delete CF
    function deleteCFs($id,$data)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->set($data)
            ->update();
    }
}
