<?php

namespace App\Models;

use CodeIgniter\Model;

class BanksModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'banks';
    protected $primaryKey       = 'BID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['BankName', 'BCardType', 'BRate', 'BStartingDate', 'BEndingDate', 'BCreatedat', 'BUpdatedAt', 'BDeletedAt', 'BStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'BCreatedat';
    protected $updatedField  = 'BUpdatedAt';
    protected $deletedField  = 'BDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    // get all bank data
    
    function getIndexNBankData(){

        $data= $this->db
        ->table('banks')
        ->where('BStatus', '1')
        ->orderBy('BID ', 'ASC')
        ->get()
        ->getResultArray();

        // echo 'hi';
        // print_r($data);
        // die();

        return $data;


    }

    // save bank data
    function insertBankData($data)
	{
    
        return $this->db
        ->table('banks')
        ->insert($data);
	}

    // get single bank data
    function getSingleBankData($id){

        return $this->db
             ->table('banks')
             ->where(["BID" => $id])
             ->get()
             ->getRow();

    }

    
    // update bank
    function updateBank($id,$data){

        // print_r($data);
        // die();
        return $this->db
        ->table('banks')
        ->where(["BID" => $id])
        ->set($data)
        ->update();

    }
    

    // delete bank
    function deleteBank($id,$data){
      
        // die();
        return $this->db
        ->table('banks')
        ->where(["BID" => $id])
        ->set($data)
        ->update();

    }
    

}
