<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Stocks extends Migration
{
    public function up()
    {
        //Create stocks table
        $this->forge->addField([
            'StockID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'BatchNO' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'Unit' => [
                'type' => 'varchar',
                'constraint' => 10,
            ],
            'Qty' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'Price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'ExpDate' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ]
        ]);

        $this->forge->addPrimaryKey('StockID');
        $this->forge->addForeignKey('ItemID', 'item', 'ItemID', 'CASCADE', 'CASCADE');
        $this->forge->createTable('stocks');
    }

    public function down()
    {
        //Drop stocks Table
        $this->forge->dropTable('stocks');
    }
}
