<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Customers extends Migration
{
    public function up()
    {
        //Create Customers Table
        $this->forge->addField([
            'id'=>[
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'first_name'=>[
                'type'=> 'varchar',
                'constraint' => 255,
            ],
            'last_name'=>[
                'type'=> 'varchar',
                'constraint' => 255,
            ],
            'birthday'=>[
                'type' => 'Date',
                'null' => true,
            ],
            'nic'=>[
                'type'=> 'varchar',
                'constraint' => 20,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('customers');
    }

    public function down()
    {
        //Drop Customers Table
        $this->forge->dropTable('customers');
    }
}
