<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Shelf extends Migration
{
    public function up()
    {
        //Create Shelf Table
        $this->forge->addField([
            'ShelfID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ShelfName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RackID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ShelfCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ShelfUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ShelfDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ShelfStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('ShelfID');
        $this->forge->createTable('shelf');
    }

    public function down()
    {
        //Drop Shelf Table
        $this->forge->dropTable('shelf');
    }
}
