<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Suppliers extends Migration
{
    public function up()
    {
        //Create Suppliers Table
        $this->forge->addField([
            'SupplierID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'SupplierImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCompanyName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBRNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierNIC' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierAddressLine1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierAddresLine2' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCity' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierProvince' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCountry' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierContactNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierEmail' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierDescription' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBankACNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('SupplierID');
        $this->forge->createTable('suppliers');
    }

    public function down()
    {
        //Drop Suppliers Table
        $this->forge->dropTable('suppliers');
    }
}
