<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\ManufacturerModel;
use App\Controllers\BaseController;

class ManufacturerController extends BaseController
{
    public function index()
    {
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Manufacturers',
            'link' => 'manufacturers'
        );
        return view('manufacturers', $data);
    }


           //create new manufacturer
           public function save() {

            // echo '<pre>';
            // print_r($_FILES);
            // die();
            
            $model = new ManufacturerModel();
            $data = [
            
                'MCompanyName' => $_POST['MCompanyName'],
                'MLicNo'=>$_POST['MLicNo'],
                'MName' => $_POST['MName'],
                'MNIC' => $_POST['MNIC'],
                'MAddressLine1' => $_POST['MAddressLine1'],
                'MAddressLine2' => $_POST['MAddressLine2'],
                'MCity' => $_POST['MCity'],
                'MProvince' => $_POST['MProvince'],
                'MCountry' => $_POST['MCountry'],
                'MContactNo' => $_POST['MContactNo'],
                'MEmail' => $_POST['MEmail'],
                'MDescription' => $_POST['MDescription'],
                'MBankName' => $_POST['MBankName'],
                'MBankAcNo' => $_POST['MBankAcNo'],
                'MCreaterAt' => date('Y-m-d H:i:s'),
                
            ];
    
            if(!empty($_FILES['MImg']['name'])){ 
                
                $imageFile = $this->request->getFile('MImg');
                $imageFile->move('../public/uploads/manImg');
                $imgDetail =$_FILES['MImg'];
                $data['MImg']= $imgDetail ['name'];
            
            }
        
          
            if($model->insertManData($data)){
                    
                return $this->response->redirect(site_url('/manufacturers'));
                    
            }
            //failure
            else
            {	
                echo json_encode(array('success'=>false,
                $data['MName']));
            }
        }
    

            //get single data
            public function singleData($id = null) {

                $model = new ManufacturerModel();      
                // $data = $model->where('EmpID', $id)->first();
    
                $data=$model->getSingleManData($id);
    
                if($data){
                    
                    echo json_encode(array("status" => true , 'data' => $data));
                }else{
                
                    echo json_encode(array("status" => false));
                }
            }
    

             //update
    public function update(){   
        
        // echo '<pre>';
        // print_r($_POST);
        // die();

        $model = new ManufacturerModel();
        
        $id = $this->request->getVar('ManID');
     
        $data = [
            'MCompanyName' => $this->request->getVar('UpMCompanyName'),
            'MLicNo'  => $this->request->getVar('UpMLicNo'),
            'MName'  => $this->request->getVar('UpMName'),
            'MNIC'  => $this->request->getVar('UpMNIC'),
            'MAddressLine1'  => $this->request->getVar('UpMAddressLine1'),
            'MAddressLine2' => $this->request->getVar('UpMAddressLine2'),
            'MCity'  => $this->request->getVar('UpMCity'),
            'MProvince'  => $this->request->getVar('UpMProvince'),
            'MCountry'  => $this->request->getVar('UpMCountry'),
            'MContactNo'  => $this->request->getVar('UpMContactNo'),
            'MEmail'  => $this->request->getVar('UpMEmail'),
            'MDescription' => $this->request->getVar('UpMDescription'),
            'MBankName'  => $this->request->getVar('UpMBankName'),
            'MBankAcNo'  => $this->request->getVar('UpMBankAcNo'),
            'MUpdatedAt	' => date('Y-m-d H:i:s'),

        
        ];

        if(!empty($_FILES['UpMImg']['name'])){ 
            
            // unlink("../public/uploads/empImg".$old_img_name);
            $imageFile = $this->request->getFile('UpMImg');
            $imageFile->move('../public/uploads/manImg');
            $imgDetail =$_FILES['UpMImg'];
            $data['MImg']= $imgDetail ['name'];
           
        }
 
    
        $result = $model->updateMan($id, $data);
        if($result) {
            return $this->response->redirect(site_url('/manufacturers'));
        }
        else{
            echo "Something went wrong";
        }
    }

     // delete employee
     public function delete($id = null){
        $now = date("Y-m-d H:i:s");
        $model = new ManufacturerModel();
        $data = [
            'MDeletedAt' => $now,
            'MStatus' => '0',
        ];
        $model->deleteMan($id, $data);
        // $model->update($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/suppliers'));
    }


    
}
