<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\EmployeeModel;
use App\Models\UserModel;
use App\Models\UserRoleModel;
class EmployeeController extends BaseController
{
    public function index()
    {
        helper('app'); 
        $user_info = getUserInfo();
        
        $EmployeeModel = new EmployeeModel();
        $URmodel = new UserRoleModel();
        
        $emp['empData'] = $EmployeeModel->getIndexData();
        $ur['User Roles']=$URmodel->getUrolesIndexData();
        
        $UserModel = new UserModel();
        $loggedUserID = session()->get('loggedUser');
        $user_info = $UserModel->getSingleUserData($loggedUserID);

        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Employees',
            'link' => 'employees',
            'sources' => $emp,
            'userroles' =>$ur,
            'userinfo' => $user_info
        );

        return view('employees', $data);
    }

    //create new employee
    public function save()
    {
        $model = new EmployeeModel();
        $data = [
        
            'EmpName' => $_POST['EmpName'],
            'EmpDesignation'=>$_POST['EmpDesignation'],
            'EmpEmail' => $_POST['EmpEmail'],
            'EmpContactNo' => $_POST['EmpContactNo'],
            'EmpDateofBirth' => $_POST['EmpDateofBirth'],
            'EmpAltContactPerson' => $_POST['EmpAltContactPerson'],
            'EmpAddressLine1' => $_POST['EmpAddressLine1'],
            'EmpAddressLine2' => $_POST['EmpAddressLine2'],
            'EmpCity' => $_POST['EmpCity'],
            'EmpProvince' => $_POST['EmpProvince'],
            'EmpCountry' => $_POST['EmpCountry'],
            'EmpNICNo' => $_POST['EmpNICNo'],
            'EmpAltNICNo' => $_POST['EmpAltNICNo'],
            'EmpAltContactNo' => $_POST['EmpAltContactNo'],
            'EmpStatus' => '1',
            'EmpCreatedAt' => date('Y-m-d H:i:s'),
            
        ];

        if(!empty($_FILES['EmpImg']['name'])){ 
            
            $imageFile = $this->request->getFile('EmpImg');
            $imageFile->move('../public/uploads/empImg');
            $imgDetail =$_FILES['EmpImg'];
            $data['EmpImg']= $imgDetail ['name'];
        
        }
    
       
       
        
        
        if($model->insertEmpData($data)){
            $id = $model->insertID();
        $userData=[
            'UserName'=>$_POST['username'],
            'UserPassword' => $_POST['cPassword'],
            'UserRole' => $_POST['RoleID'],
        ];

            $userData=[
                'UserName'=>$_POST['username'],
                'UserPassword' => $_POST['password'],
                'cPassword' => $_POST['cPassword'],
                'userRoleId' => $_POST['RoleID'],
                'EmpID'=>$id ,
               
            ];

        //     echo '<pre>';
        // print_r($userData);
        // die();

            if($_POST['username'] ){

                $this->createUserData($userData);
                    
            }

         
            return $this->response->redirect(site_url('/employees'));
                
        }
        //failure
        else
        {	
            echo json_encode(array('success'=>false,
            $data['EmpName']));
        }
    }

    public function createUserData($userData){

        // echo '<pre>';
        // print_r($userData);
        // die();


        $model = new UserModel();
       
        if( $model->insertUserData($userData)){
            return $this->response->redirect(site_url('/employees'));
        }
    }

    //get single data
    public function singleData($id = null) {

        // print_r($id);
       
        // die();
          
        $modeluser = new UserModel();   
       
        $model = new EmployeeModel();

      
       

        $data2=$modeluser->getSingleEmpData($id);

        if($data2){
           
            $data=$model->getUserEmployeeJoinData($id);
            //$data='data2';
        }
        else{
             $data=$model->getSingleEmpData($id);
            //$data='data';
        }
        
       
       
        // die();

        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
        
            if($data){
            
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
            
                echo json_encode(array("status" => false));
            }
        


      
    }
}

    //update
    public function update(){    
        $model = new EmployeeModel();
        
        $id = $this->request->getVar('EmpId');
        // echo '<pre>';
        // print_r($_POST);
       
        // die();
        $data = [
            'EmpName' => $this->request->getVar('EmpName'),
            'EmpDesignation'  => $this->request->getVar('EmpDesignation'),
            'EmpEmail'  => $this->request->getVar('EmpEmail'),
            'EmpContactNo'  => $this->request->getVar('EmpContactNo'),
            'EmpDateofBirth'  => $this->request->getVar('EmpDateofBirth'),
            'EmpAltContactPerson' => $this->request->getVar('EmpAltContactPerson'),
            'EmpAddressLine1'  => $this->request->getVar('EmpAddressLine1'),
            'EmpAddressLine2'  => $this->request->getVar('EmpAddressLine2'),
            'EmpCity'  => $this->request->getVar('EmpCity'),
            'EmpProvince'  => $this->request->getVar('EmpProvince'),
            'EmpCountry'  => $this->request->getVar('EmpCountry'),
            'EmpNICNo' => $this->request->getVar('EmpNICNo'),
            'EmpAltNICNo'  => $this->request->getVar('EmpAltNICNo'),
            'EmpAltContactNo'  => $this->request->getVar('EmpAltContactNo'),
            'EmpUpdatedAt' => date('Y-m-d H:i:s'),
        
        ];

        if(!empty($_FILES['EmpImg']['name'])){ 
            
            $imageFile = $this->request->getFile('EmpImg');
            $imageFile->move('../public/uploads/empImg');
            $imgDetail =$_FILES['EmpImg'];
            $data['EmpImg']= $imgDetail ['name'];
        }

      if($this->request->getVar('UserID')){

        $datau['EmpID']= $id;
        $datau['UserName']= $this->request->getVar('username');
        $datau['UserPassword']= $this->request->getVar('password');
        $datau['cPassword']= $this->request->getVar('cPassword');
        $datau['UserRoleId']= $this->request->getVar('RoleID');
        $datau['UserUpdatedAt'] = date('Y-m-d H:i:s');

        $userModel= new UserModel;
        $resultUser = $userModel->updateUser($id, $datau);

      
      }
      else{
        $datau['EmpID']= $this->request->getVar('EmpId');
        $datau['UserName']= $this->request->getVar('username');
        $datau['UserPassword']= $this->request->getVar('password');
        $datau['cPassword']= $this->request->getVar('cPassword');
        $datau['UserRoleId']= $this->request->getVar('RoleID');
        $datau['UserCreatedAt'] = date('Y-m-d H:i:s');
        
        

        $userModel= new UserModel;
        $resultUser = $userModel->insertUserData( $datau);
      }

    //   echo '<pre>';
    //   print_r($data);
    //   die();

        $result = $model->updateEmp($id, $data);
        if($result) {
            return $this->response->redirect(site_url('/employees'));
        }
        else{
            echo "Something went wrong";
        }
    }

    // delete employee
    public function delete($id = null){
        $now = date("Y-m-d H:i:s");
        $model = new EmployeeModel();
        $userModel= new UserModel();
        $data = [
            'EmpDeletedAt' => $now,
            'EmpStatus' => '0',
        ];

        $datau=[
            'UserDeletedAt'=>$now,
            'UserStatus' => '0',
            
        ];

        $model->deleteEmp($id, $data);
        $userModel->deleteUser($id, $datau);
        
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/employees'));
    }
}
