<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\UnitsModel;
use App\Models\ConversionFactorModel;
use App\Controllers\BaseController;

class ConversionFactorController extends BaseController
{
    private $UserModel = null;
    private $UnitsModel = null;
    private $ConversionFactorModel = null;
    private $now = null;

    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->UnitsModel = new UnitsModel();
        $this->ConversionFactorModel = new ConversionFactorModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }
    public function index()
    {        
        $user_info = getUserInfo(); 
        $allunits = $this->UnitsModel->getAllUnitsData();
        $allCFs = $this->ConversionFactorModel->getAllCFsData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Unit & Meatures',
            'link' => 'unitandmeatures',
            'userinfo' => $user_info,
            'allunits' => $allunits,
            'allCFs' => $allCFs,
            'has_errors' =>$has_errors,
        );
        return view('unitconversionfactors', $data);
    }
// add CF data
    public function addupCFs()
    { 
                $validation = $this->validate([
                'cfFromUnit' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select value',
                    ],
                ],
                'cfToUnit' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select value',
                    ],
                ],
                'cfFactor' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter value',
                    ],
                ],
            
            ]);
            if($validation){
                    $cfID = $this->request->getVar('cfID');
                    if($cfID == ''){  //insert cf details
                        $data = [
                            'FromUnitiD' => $this->request->getVar('cfFromUnit'),
                            'ToUnitID'  => $this->request->getVar('cfToUnit'),
                            'CFFactor'  => $this->request->getVar('cfFactor'),
                            'CFCreatedAt' => $this->now,
                            'CFStatus' => '1',
                        ];
                        $this->ConversionFactorModel->insertCFs($data);  
                    }
                    else{  //update cf 
                        $data = [
                            'FromUnitiD' => $this->request->getVar('cfFromUnit'),
                            'ToUnitID'  => $this->request->getVar('cfToUnit'),
                            'CFFactor'  => $this->request->getVar('cfFactor'),
                            'CFUpdatedAt' => $this->now,
                        ];
                        $this->ConversionFactorModel->updateCFs($cfID, $data);
                    }
                        
                    return $this->response->redirect(site_url('/conversion_factor'));
            }
            else{
                $user_info = getUserInfo(); 
                $allunits = $this->UnitsModel->getAllUnitsData();
                $allCFs = $this->ConversionFactorModel->getAllCFsData();
                $has_errors = 'true';
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Unit & Meatures',
                    'link' => 'unitandmeatures',
                    'userinfo' => $user_info,
                    'allunits' => $allunits,
                    'allCFs' => $allCFs,
                    'validation'=>$this->validator,
                    'has_errors' => $has_errors,
                );
                return view('unitconversionfactors', $data);
            }
    }
    //get single CF
    public function singleCFs($id = null)
    {
        $data = $this->ConversionFactorModel->getSingleCFData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete CFs
    public function deleteCF($id = null){
        $data = [
            'CFDeletedAt' => $this->now,
            'CFStatus' => '0',
        ];

        $this->ConversionFactorModel->deleteCFs($id, $data);

        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }
}
