<?php $this->extend('layouts/master') ?>

<?php $this->section('pricerules') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="flex-fill bd-highlight">
                                        <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                            <div class="d-flex bd-highlight">
                                                <div class="flex-fill bd-highlight">
                                                    <div class="ms-2 py-0 text-primary fw-bold">
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                            <a href="/payment_terms" class="text-secondary text-decoration-none">    
                                                                Payment Terms
                                                            </a>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                            <a href="/payment_types" class="text-secondary text-decoration-none">    
                                                                Payment Types
                                                            </a>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#pruleModel"><i class="bi bi-plus-lg fw-bold"></i> New Price Rule </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Pr Name</th>
                                            <th class="p-2" scope="col">Pr Type</th>
                                            <th class="p-2" scope="col">pr value</th>
                                            <th class="p-2" scope="col">From</th>
                                            <th class="p-2" scope="col">To</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                                
                                            ?>
                                            <tr id="<?php echo $s['pr_id']; ?>">     
                                                <td><?php echo $s['pr_name']; ?></td>
                                                <td><?php echo $s['pr_type']; ?></td>
                                                <td><?php echo $s['pr_value']; ?></td>
                                                <td><?php echo $s['pr_started_date']; ?></td>
                                                <td><?php echo $s['pr_end_date']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="predit" type="button" data-bs-toggle="modal" data-bs-target="#pruleModel" data-id="<?php echo $s['pr_id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="prdelete" type="button" data-id="<?php echo $s['pr_id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- start prule  insert and update model -->
        <div class="modal fade" id="pruleModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">PriceRule Detail Form</h5>
                        <button type="button" id="closefrm" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add_prules" name="add_prules" action="<?= site_url('/submit_price_rules') ?>">                           
                            <div class="row">   
                                <input type="hidden" class="form-control mb-3" name="pr_id" id="pr_id"  hidden  value="<?php echo set_value('pr_id');?>">                          
                                <div class="mb-3 col">
                                    <label for="type" class="col-form-label">Price Rule Type:</label>   
                                    <select class="form-control" name="pr_type" id="pr_type">
                                        <option value="">Please Select a Type</option> 
                                        <option value="Credit Card" <?php echo set_select('BCardType', 'Credit Card'); ?> >Credit Card</option>
                                        <option value="Debit Card" <?php echo set_select('BCardType', 'Debit Card'); ?> >Debit Card</option>
                                        <option value="Loyality" <?php echo set_select('BCardType', 'Loyality'); ?> >Loyality</option>
                                        <option value="Other" <?php echo set_select('BCardType', 'Other'); ?> >Other</option>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_type') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="type" class="col-form-label">Discount Attributes:</label>   
                                    <select class="form-control" name="pr_dattr" id="pr_dattr">
                                        <option value="">Please Select a Discount Attribute</option>
                                        <option value="Default" <?php echo set_select('PRDiscountAttr', 'Default'); ?> >Default</option>
                                        <option value="For Specific Amount" <?php echo set_select('PRDiscountAttr', 'For Specific Amount'); ?> >For Specific Amount</option>
                                        <option value="For Specific Items" <?php echo set_select('PRDiscountAttr', 'For Specific Items'); ?> >For Specific Items</option>
                                        <option value="Other" <?php echo set_select('PRDiscountAttr', 'Other'); ?> >Other</option>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_dattr') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                 <div class="mb-3 col" id="amountattr">
                                    <label for="prval" class="col-form-label">Enter Price Rule Value:</label>  
                                    <input type="text" class="form-control"  value="<?php echo set_value('pr_value');?>" name="pr_value" id="pr_value" placeholder="Enter value">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_value') : '' ?></h6>
                                </div>
                                <div class="mb-3 col" id="itemattr">
                                    <label for="item" class="col-form-label">Select an Item:</label>
                                    <!--select class="form-control" name="pr_items" id="pr_items"-->
                                    <select class="form-control js-example-basic-multiple" name="pr_items[]" id="pr_items" multiple>
                                        <?php
                                            if ($items):
                                            foreach ($items as $item):
                                        ?>
                                                <option <?php echo set_select('pr_items',  $item['ItemID']); ?> value="<?php echo $item['ItemID']; ?>"><?php echo $item['ItemID']; ?>-<?php echo $item['ItemName']; ?></option>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_items') : '' ?></h6>
                                    <!-- <div class="custom-multiselect"> -->
                                        <div class="selected-values"></div>
                                        <!-- <div class="dropdown"> -->
                                        <select class="form-control js-example-basic-multiple" name="pr_items[]" id="pr_items" multiple>
                                        <?php
                                            if ($items):
                                            foreach ($items as $item):
                                        ?>
                                                <option <?php echo set_select('pr_items',  $item['ItemID']); ?> value="<?php echo $item['ItemID']; ?>"><?php echo $item['ItemID']; ?>-<?php echo $item['ItemName']; ?></option>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                        <!-- </div> -->
                                    <!-- </div> -->
                                </div>
                            </div>                            
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="bank" class="col-form-label">Select a Bank:</label>  
                                    <select class="form-control" name="pr_bank" id="pr_bank">
                                        <option value="">Please Select a bank</option> 
                                        <?php
                                            if ($banks):
                                            foreach ($banks as $bank):
                                        ?>
                                                <option <?php echo set_select('pr_bank',  $bank['BID']); ?> value="<?php echo $bank['BID']; ?>"><?php echo $bank['BID']; ?>-<?php echo $bank['BankName']; ?></option>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_bank') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="rate" class="col-form-label">Enter Rate:</label>  
                                    <input type="text" class="form-control"  value="<?php echo set_value('pr_rate');?>" name="pr_rate" id="pr_rate" placeholder="Enter rate">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_rate') : '' ?></h6>
                                </div>  
                                <!--test date picker  -->
                                <!-- <div id="datepicker-container" class="datepicker-container">
                                    <span class="outline-element-container"> 
                                    <input id="datepicker-input" type="text" class="openemr-datepicker input-textbox outline-element incorrect" placeholder="Type Name" objtype="7" name="action_element" objindex=""  aria-label="Select Date"> <span class="correct-incorrect-icon"> </span></span>
                                    <div id="datepicker"></div>
                                </div>
                                <div class="datepicker-container openemr-calendar" id="datepicker-div" ></div> -->
                                <!--test date picker  -->
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="name" class="col-form-label">Enter Name:</label>  
                                    <input type="text" class="form-control"  value="<?php echo set_value('pr_name');?>" name="pr_name" id="pr_name" placeholder="Enter name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_name') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                               <div class="mb-3 col">
                                    <label for="sdate" class="col-form-label">Enter Started Date:</label>  
                                    <input type="date" class="form-control"   placeholder="Enter started date" value="<?php echo set_value('pr_started_date');?>" name="pr_started_date" id="pr_started_date" >
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_started_date') : '' ?></h6>
                                </div> 
                                <div class="mb-3 col">
                                    <label for="edate" class="col-form-label">Enter End Date:</label>  
                                    <input type="date" class="form-control"   min="2018-01-01"  placeholder="Enter end date" value="<?php echo set_value('pr_end_date');?>" name="pr_end_date" id="pr_end_date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pr_end_date') : '' ?></h6>
                                </div>                    
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit" >Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- end  pricerules insert and update  model -->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>        
        function openPrulesModal(){
            var bank_modal = $("#pruleModel");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                bank_modal.modal('show');
            }
        }

        $(document).ready(function() {
            openPrulesModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [{
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                }],
            });

            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });

            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });

            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }
        $("#tmethods").hide();

        $("#dmethods").hide();
        $("#dattibutes").hide();
        $("#amountattr").hide();
        $("#itemattr").hide();

        $("body").on("change", "#pr_type", function(e){
            e.preventDefault();
            var prtype = $(this).val();

            $("#tmethods").hide();
            $("#tmethods").val('');

            $("#dmethods").hide();
            $("#dmethods").val('');

            $("#dattibutes").hide();
            $("#dattibutes").val('');
            
            $("#amountattr").hide();
            $("#amountattr").val('');

            $("#itemattr").hide();
            $("#itemattr").val('');

            if(prtype == "Tax"){
                $("#tmethods").show();
            }else if(prtype == "Discount"){
                $("#dmethods").show();
                $("#dattibutes").show();
            }else{

            }
        });

        $("body").on("change", "#pr_dattr", function(e){
            e.preventDefault();
            var dattr = $(this).val();
            
            $("#amountattr").hide();
            $("#amountattr").val('');

            $("#itemattr").hide();
            $("#itemattr").val('');

            if(dattr == 'For Specific Amount'){                        
                $("#amountattr").show();
            }else if(dattr == 'For Specific Items'){
                $("#itemattr").show();
            }else{

            }
        });

        //update price_rules
        $('body').on('click', '#predit', function () {
            var pr_id = $(this).attr('data-id');
            $.ajax({
                url: 'price_rules_edit/'+pr_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#pruleModel').modal('show');
                    $('#add_prules #pr_id').val(res.data.pr_id); 
                    $('#add_prules #pr_type').val(res.data.pr_type); 
                    $('#add_prules #pr_name').val(res.data.pr_name);
                    $('#add_prules #pr_value').val(res.data.pr_value);
                    $('#add_prules #pr_items').val(res.data.pr_items);
                    $('#add_prules #pr_bank').val(res.data.pr_bank);
                    $('#add_prules #pr_rate').val(res.data.pr_rate);
                    $('#add_prules #pr_started_date').val(res.data.pr_started_date);
                    $('#add_prules #pr_end_date').val(res.data.pr_end_date);
                    
                },
                    error: function (data) {
                }
            });
        });

         //delete prule
         $('body').on('click', '#prdelete', function () {
            var pruleId = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ pruleId).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'price_rule_delete/'+pruleId,
                        async: false,
                        success: function(data){ 
                            location.reload()                          
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ pruleId).remove();
                            }
                        }
                    });
                }
            });          
        });

        //start and end date 
        $("body").on("change", "#pr_started_date", function () {
            var myDate = new Date($(this).val());
            var d = new Date(myDate),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();

            if (month.length < 2) month = '0'+ month;
            if (day.length < 2) day = '0'+day;

            var minDate = [year, month, day].join('-');
            //alert(minDate);
            $("#pr_end_date").attr('min',minDate);
        });
        
        //reset form
        $('#pruleModel').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submit').disabled = true;
        });
       
    </script>
<?php $this->endSection() ?>