<?php $this->extend('layouts/master') ?>

    <?php $this->section('items') ?>
        
        <?php echo view('includes/footer'); ?>
        <!---List of items --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row px-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-pen-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-upc-scan"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <div class="dropdown">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="dropdownMenuButton2" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="bi bi-funnel-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu linear-bg text-secondary px-2 py-2" aria-labelledby="dropdownMenuButton2">
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                    <label class="form-check-label" for="flexCheckDefault"> Low Inventory Items</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked" checked>
                                                                    <label class="form-check-label" for="flexCheckChecked">Serialized Items</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" name="ItemIsSerialized" value="1" id="ItemIsSerialized" />
                                                                    <label class="form-check-label" for="ItemIsSerialized">Item Is Serialized</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="search" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                              
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-1 me-1 py-0 text-primary fw-bold">
                                                  <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#itemAddModel"><i class="bi bi-plus-lg fw-bold"></i> 
                                                        New Item 
                                                  </button>
                                                  <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/stock" class="text-secondary text-decoration-none">    
                                                             Stock Management
                                                        </a>
                                                    </button>
                                                   <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/unitandmeatures" class="text-secondary text-decoration-none">    
                                                             Unit of measure
                                                        </a>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/item_category_information" class="text-secondary text-decoration-none">    
                                                             Item Category Info
                                                        </a>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/price_management" class="text-secondary text-decoration-none">    
                                                             Managing Selling And Purchasing Price
                                                        </a>
                                                    </button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                

                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle" id="viewtable">
                                        <thead class="text-center text-secondary">
                                            <!-- <th class="rounded-start p-2" scope="col">
                                                <span class="all-select-check-box-col rounded">
                                                    <input class="form-check-input selectAll" type="checkbox" value="" id="flexCheckDefault" onclick="javascript:checkAll(this)">
                                                </span>
                                            </th> -->
                                            <th class="p-2" scope="col">Item Name</th>
                                            <th class="p-2" scope="col">Category</th>
                                            <th class="p-2" scope="col">Default Unit</th>
                                            <th class="p-2" scope="col">Tags</th>
                                            <th class="p-2" scope="col">Reorder Level</th>
                                            <th class="p-2" scope="col">Item is Serialized</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2" scope="col">Action</th>                                           
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source):
                                                    if($source['delete_flag'] != '1'):                                 
                                            ?>
                                                <tr id="<?php echo $source['ItemID']; ?>">
                                                    <!-- <th scope="row">
                                                        <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1">
                                                            <input class="form-check-input select-checkbox" type="checkbox" value="" id="flexCheckDefault">
                                                        </div>
                                                    </th> -->
                                                    <td><?php echo $source['ItemName']; ?></td>
                                                    <td><?php echo $source['ICName']; ?></td>
                                                    <td><?php echo $source['UnitName']; ?></td>
                                                    <td><?php echo $source['ItemTags']; ?></td>
                                                    <td><?php echo $source['ItemReorderLevel']; ?></td>
                                                    <td>
                                                        <?php 
                                                            if($source['ItemIsSerialized'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="turnoffserialize" data-id="<?php echo  $source['ItemID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="turnonserialize" data-id="<?php echo  $source['ItemID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                    </td>
                                                    <td>
                                                    <?php 
                                                            if($source['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $source['ItemID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $source['ItemID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                    </td>                                                    
                                                    <td>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="itemedit" data-bs-toggle="modal" data-id="<?php echo  $source['ItemID']; ?>"  data-bs-target="#itemAddModel">
                                                            <i class="bi bi-pen-fill"></i>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="itemdelete"  data-id="<?php echo  $source['ItemID']; ?>" >
                                                            <i class="bi bi-trash3-fill"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php
                                                    endif;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Start Insert and Update items --->
        <div class="modal fade" id="itemAddModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Item form detail</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="/item_save" enctype="multipart/form-data" id="add_item" method="post" accept-charset="utf-8">
                            <div class="row">
                            <div class="mb-3 col">
                                    <label for="tags" class="col-form-label">Enter Item Tags:</label>  
                                    <input type="text" class="form-control" id="ItemTags"  value="<?php echo set_value('ItemTags');?>"  name="ItemTags" placeholder="Enter Item Tags">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemTags') : '' ?></h6>  
                                </div>                                                     
                                <div class="mb-3 col">
                                    <label for="cat" class="col-form-label">Please select a category:</label>  
                                        <select class="form-control" name="ItemCategory" id="ItemCategory">
                                            <option value="">Please Select the Category</option> 
                                                <?php                                        
                                                    if($ItemCategories):
                                                    foreach($ItemCategories as $ItemCategory):
                                                        // $staticValue = "ItemCategory";
                                                        
                                                ?>                                  
                                                <option id=" <?php echo $ItemCategory['ICID']; ?>" value="<?php echo $ItemCategory['ICID']; ?>" <?php echo set_value('ItemCategory') == $ItemCategory['ICID'] ? 'selected' : ''; ?> class="cat ">
                                                    <?php
                                                        $levelSpace = '';
                                                        for ($i = 1; $i <= $ItemCategory['ICLevel']; $i++) {
                                                            if ($i <= $ItemCategory['ICLevel']) {
                                                                $levelSpace .= '&nbsp;&nbsp;&nbsp;';
                                                            }
                                                        }
                                                        if($ItemCategory['ICParentID'] == ''){
                                                            echo $ItemCategory['ICID'].' - '. $ItemCategory['ICName'];
                                                            // echo $ItemCategory['ICName'];
                                                        }else{
                                                            echo $levelSpace .$ItemCategory['ICID'].' - '. $ItemCategory['ICName'];
                                                            // echo $levelSpace.$ItemCategory['ICName'];
                                                        }
                                                        
                                                    ?>
                                                </option>
                                                <?php
                                                    endforeach;
                                                    endif;
                                                ?>
                                        </select>
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemCategory') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="desc" class="col-form-label">Enter Item Description:</label>  
                                    <input type="text" class="form-control" id="ItemDescription"  value="<?php echo set_value('ItemDescription');?>" name="ItemDescription" placeholder="Enter Item Description">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemDescription') : '' ?></h6>  
                                </div>
                                <div class="mb-3 col">
                                    <input type="hidden" class="form-control mb-3" name="ItemID" id="ItemID"  hidden  value="<?php echo set_value('ItemID');?>">
                                    <label for="itmname" class="col-form-label">Item Name:</label>  
                                    <input type="text" class="form-control" id="ItemName"  value="<?php echo set_value('ItemName');?>" name="ItemName" placeholder="Enter Item Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemName') : '' ?></h6>  
                                </div> 
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="desc" class="col-form-label">Please Select the Base Unit:</label>                                     
                                    <select class="form-control" name="ItemUnit" id="ItemUnit">                                        
                                        <option value="">Please Select the Base Unit</option> 
                                        <?php                                        
                                            if($Units):
                                            foreach($Units as $Unit):
                                        ?>
                                        <option value="<?php echo $Unit['UnitID']; ?>"  <?php echo set_value('ItemUnit') == $Unit['UnitID'] ? 'selected' : ''; ?> required >
                                            <?php echo  $Unit['UnitID'] .' - '.$Unit['UnitName']; ?></option>                                    
                                        <?php
                                            endforeach;
                                            endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemUnit') : '' ?></h6>  
                                </div>
                                <div class="mb-3 col">
                                    <label for="reorderlevel" class="col-form-label">Enter Item Reorder Level:</label>         
                                    <input type="number" placeholder="5" class="form-control disableletter " id="ItemReorderLevel"  value="<?php echo set_value('ItemReorderLevel', '5');?>" name="ItemReorderLevel" placeholder="Enter Item Reorder Level">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemReorderLevel') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row mb-12">
                                <div class="mb-12 col">
                                    <label for="desc" class="col-form-label">Please Select Derived Units:</label>
                                    <div class="mb-12 col">    
                                        <?php                                        
                                            if($Units):
                                            foreach($Units as $Unit):
                                        ?>
                                            <input type="checkbox" class="otherunitscheckbox" name="ItemOtherUnits[]" id="<?php echo $Unit['UnitID']; ?>" value="<?php echo $Unit['UnitID']; ?>" > <?php echo $Unit['UnitName'];  ?>&nbsp;&nbsp;&nbsp;&nbsp;
                                        <?php
                                            endforeach;
                                            endif;
                                        ?>
                                    </div>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemOtherUnits') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row mb-12">
                                <div class="wrapper col">
                                    <label for="reorderlevel" class="col-form-label">Select an image :</label>         
                                    <div class="box">
                                        <div class="js--image-preview">
                                            <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                        </div>
                                        <div class="upload-options">
                                            <label>
                                                <input type="file" class="image_upload" accept="image/*" name="ItemImg" id="ItemImg ">
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col"> 
                                <label for="itemtype" class="col-form-label">Select Item Type:</label>      
                                <select class="form-control" name="ItemType" id="ItemType">
                                    <option  value="" >Select Item Type</option>
                                    <option selected value="1" <?php echo  set_select('ItemType', '1'); ?> >Manufacture</option>
                                    <option value="2" <?php echo  set_select('ItemType', '2'); ?> >Service</option>
                                    <option value="3" <?php echo  set_select('ItemType', '3'); ?> >Purchasing</option>
                                    </select>   
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemType') : '' ?></h6>    
                                </div>
                                <div class="mb-3 col"> 
                                <label for="itemtype" class="col-form-label">Select Item Status:</label>      
                                <select class="form-control" name="ItemStatusValue" id="ItemStatusValue">
                                    <option value="" >Select Item Status</option>
                                    <option selected value="1" <?php echo  set_select('ItemStatusValue', '1'); ?> >New</option>
                                    <option value="2" <?php echo  set_select('ItemStatusValue', '2'); ?> >Used</option>
                                    <option value="3" <?php echo  set_select('ItemStatusValue', '3'); ?> >Aging</option>
                                    <option value="4" <?php echo  set_select('ItemStatusValue', '4'); ?> >Damaged</option>
                                    </select>   
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemStatusValue') : '' ?></h6>    
                                </div>
                            </div>   
                            <div class="row">
                                <div class="mb-3 col"> 
                                    <input class="form-check-input" name="ItemIsSerialized" type="checkbox" value="1" id="ItemIsSerialized">
                                    <label class="form-check-label ms-1" for="ItemIsSerialized"> : Item Is Serialized </label>
                                </div>
                                <div class="mb-3 col"> 
                                    <input class="form-check-input"  name="ItemReturnable" type="checkbox" <?php echo set_checkbox('ItemReturnable', '1');?>  value="1" id="ItemReturnable">
                                    <label class="form-check-label ms-1" for="ItemReturnable"> :Item Can Not Be Return </label>
                                </div>
                            </div>   
                            <div class="modal-footer ">
                                <div class="d-flex align-items-start">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitBtn" onclick="submitForm(e)">Submit</button>
                                </div>
                            </div>   
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <!--- End Insert and Update items --->       
    </section>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
         function openItemAddModal(){
            var itemAdd_modal = $("#itemAddModel");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                itemAdd_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openItemAddModal();
            $('#viewtable, #viewtable1').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            ItemTable = $('#viewtable, #viewtable1').DataTable();
            $('#vtSearch').keyup(function(){
                ItemTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    ItemTable.rows().select();        
                } else {
                    ItemTable.rows().deselect(); 
                }
            });
            
            $("body").on("change", "#ItemUnit", function(e){
                e.preventDefault();
                var dUnit = $(this).val();
                
                $('input[name="ItemOtherUnits[]"]').prop('disabled', false);
                $('input[name="ItemOtherUnits[]"][value="'+dUnit+'"]').prop('disabled', true);
            });
        });
        $.extend( DataTable.ext.classes, {
            "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
            "sWrapper": "row text-center ms-auto me-auto mt-2",                    
            "sFilter": "dnone",
        });


        // suggest item name based on item tag, category and description
         
        //    $('#ItemTags').change(function(event)
        //    {
        //         var ItemTags= this.value;
        //         $('#ItemCategory').change(function(event){
        //             var ItemCategoryidval= this.value;

        //             var ItemCategory= $(this).find('option:selected').text();
        //             var trimmedStr = $.trim(ItemCategory);
        //             var parts = trimmedStr.split(" - ");
        //             var catname=parts[1];
        //             console.log(trimmedStr)
        //             $('#ItemDescription').change(function(event){
        //                 var ItemDescription= this.value;

        //                 var ItemName=ItemTags +" " +catname+" " +ItemDescription
        //                 // console.log(ItemName)
        //                 $('#ItemName').val(ItemName);
        //                         });
        //         });
        //         // console.log(ItemTags);
              
        //     });
                          
        //update items
        $('body').on('click', '#itemedit', function () {
            var ItemID  = $(this).attr('data-id');
            //alert(ItemID);
            $.ajax({
                url: 'item_edit/'+ItemID ,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res.data);
                        $('#add_item #ItemName').val(res.data[0].ItemName);
                        $('#add_item #ItemCategory').val(res.data[0].ItemCategory); 
                        $('#add_item #ItemTags').val(res.data[0].ItemTags);
                        $('#add_item #ItemDescription').val(res.data[0].ItemDescription);
                        $('#add_item #ItemReorderLevel').val(res.data[0].ItemReorderLevel);
                        $('#add_item #ItemUnit').val(res.data[0].ItemUnit);
                        $('#add_item #ItemType').val(res.data[0].ItemType);
                        $('#add_item #ItemStatusValue').val(res.data[0].ItemStatusValue);
                        $('#add_item #ItemIsSerialized').val(res.data[0].ItemIsSerialized);
                        if(res.data[0].ItemIsSerialized==1){
                            $('#add_item #ItemIsSerialized').prop("checked", true);
                        }
                        if(res.data[0].ItemReturnable==1){
                            $('#add_item #ItemReturnable').prop("checked", false);
                        }
                        // else{ $('#add_item #ItemReturnable').prop("checked", false);

                        // }
                        $('#add_item #ItemID').val(res.data[0].ItemID);
                        $('#add_item #design').attr('src','/uploads/itemImg/'+ res.data[0].ItemImg);
                        var checkedvalue=res.data[0].ItemOtherUnits;                    
                        var arraydb = checkedvalue.split(',');
                        console.log(checkedvalue);
                       
                        $.each(arraydb, function(index, value) {
                            // Find the corresponding checkbox
                            var checkbox = $('.otherunitscheckbox[value="' + value + '"]');
                            $('.otherunitscheckbox[value="' +res.data[0].ItemUnit + '"]').prop('disabled', true);
                            // Set the "checked" property to true
                            checkbox.prop('checked', true);
                        });
                        $(this).find('form').trigger('reset');
                   
                },
                    error: function (data) {
                }
            });
        });

        //delete items
        $('body').on('click', '#itemdelete', function () {
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.get('item_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                    swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                  
                      })
                   
                }
            });          
        });

    
        //items turn off serialize
        $('body').on('change', '#turnoffserialize', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('off_serialize/'+itemid, function (data) {                
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":not(:checked)");
                // }
            })
        });
        
        //items turn on serialize
        $('body').on('change', '#turnonserialize', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('on_serialize/'+itemid, function (data) {
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":checked");
                // }
            })
        }); 

        //items disable
        $('body').on('change', '#enable', function () {
            var itemid = $(this).attr('data-id');
            console.log(itemid);
            $.getJSON('disable_item/'+itemid, function (data) {                
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":not(:checked)");
                // }
            })
        });
        
        //items enable
        $('body').on('change', '#disable', function () {
            var itemid = $(this).attr('data-id');
            // alert(itemid);
            $.getJSON('enable_item/'+itemid, function (data) {
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":checked");
                // }
            })
        });
        
          //reset form
        $('#itemAddModel').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

               // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submitBtn').disabled = true;
        });
    </script>

<?php $this->endSection() ?>
