<?php $this->extend('layouts/master') ?>

<?php $this->section('functionality') ?>

        <!---List of functionality --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#functionalityModal"><i class="bi bi-plus-lg fw-bold"></i> New Functionality </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Functionality Name</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($functionalities):
                                                foreach($functionalities as $functionality): 
                                                foreach($functionality as $f): 
                                                
                                            ?>
                                            <tr id="<?php echo $f['FID']; ?>">     
                                                <td><?php echo $f['FName']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($f['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $f['FID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $f['FID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <?php 
                                            if($f['FID']=='1'){
                                           ?>
                                           <td>
                                           </td>
                                           <?php }
                                            else{
                                           ?>
                                            <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="functionalityedit" type="button" data-bs-toggle="modal" data-bs-target="#functionalityModal" data-id="<?php echo $f['FID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="functionalitydelete" type="button" data-id="<?php echo $f['FID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                        </tr>
                                            <?php
                                            }
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start insert and update functionality model -->
        <div class="modal fade" id="functionalityModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">  Functionality Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="functionality" name="add_functionality" action="<?= site_url('/submit_functionality') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                    <input type="hidden" class="form-control mb-3" name="FID" id="FID"  hidden value="<?php echo set_value('FID');?>">
                                    <label for="functionality" class="col-form-label">Enter Functionality:</label>  
                                    <input type="text" class="form-control" name="FName" value="<?php echo set_value('FName');?>" id="FName" placeholder="Enter Functionality Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'FName') : '' ?></h6>
                                </div>
                            </div>                   
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- end  insert and update functionality model -->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
            function openFunctionModal(){
            var function_modal = $("#functionalityModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                function_modal.modal('show');
            }
        }

        $(document).ready(function() {
           openFunctionModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
            //delete items
            $('body').on('click', '#functionalitydelete', function () 
            {
                    var id = $(this).attr('data-id');
                swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.get('functionality_delete/'+id, function (data) {
                    if(data.error)
                        // alert('Can not delete, this record has related information');    
                        swal.fire({
                            title: 'Can not delete',
                            text: data.message,
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    else
                        swal.fire({
                            title: 'Deleted',
                            text: "This record has deleted Successfully!",
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',                       
                        }).then((result) => {
                            location.reload();
                            $('#viewtable tbody #'+ id).remove();
                        });
                    
                        })
                
                  }
               });          
          });

        //update functionality
        $('body').on('click', '#functionalityedit', function () 
        {
            var functionality_id = $(this).attr('data-id');
            $.ajax({
                url: 'functionality_edit/'+functionality_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#functionalityModal').modal('show');
                    $('#functionality #FID').val(res.data.FID); 
                    $('#functionality #FName').val(res.data.FName); 
                },
                    error: function (data) {
                }
            });
        });
 
          //functionality enable
          $('body').on('change', '#disable', function () 
        {
            var id = $(this).attr('data-id');
            //  alert(id);
            $.getJSON('enable_functionality/'+id, function (data) {                
              location.reload();
                    })
        });
        
            //functionality disable 
         $('body').on('change', '#enable', function () 
        {
                var id = $(this).attr('data-id');
                // alert(id);
                $.getJSON('disable_functionality/'+id, function (data) {
                    location.reload();
                })
        });
        //reset form
        $('#functionalityModal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
            });
             // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submit').disabled = true;
            });
                  
    </script>
<?php $this->endSection() ?>