<?php $this->extend('layouts/master') ?>

<?php $this->section('receivingsTempList') ?>
    <!--- Sale Status --->       
    <div class="container-fluid mt-3 list-of-customer">
        <?php $validation = \Config\Services::validation(); ?>
        <div class="row p-2">
            <div class="col-12">
                <div class="row">
                    <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                        <!--div class="d-flex bd-highlight">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                <i class="bi bi-trash3-fill"></i>
                                            </button>
                                        </div>
                                        <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                <i class="bi bi-envelope-fill"></i>
                                            </button>
                                        </div>
                                        <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                            <div class="searchbar linear-bg">
                                                <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <div class="ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#supplierModal"><i class="bi bi-plus-lg fw-bold"></i> New Supplier </button>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div-->
                        <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table" id="tempRecTable">
                            <div class="tableFixHead mt-2">
                            <input hidden type="text" id="has_errors" name="has_errors" value="">
                                <table class="table rounded align-middle rounded" id="viewtable">
                                    <thead class=" text-center text-secondary rounded">
                                        <th class="p-2" scope="col">Cart No</th>
                                        <th class="p-2" scope="col">Date</th>
                                        <th class="p-2 rounded-end" scope="col">Actions</th>
                                    </thead>
                                    <tbody class="text-primary text-center fw-bold">
                                        <?php 
                                            if($tempReceivings):
                                                foreach($tempReceivings as $tempReceiving):
                                        ?>                                    
                                                <tr id="<?php echo $tempReceiving['CartID']; ?>">
                                                    <td><?php echo $tempReceiving['CartID']; ?></td>
                                                    <td><?php echo $tempReceiving['RCreatedAt']; ?></td>
                                                    <td>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" id="tempReceivingsedit" type="button" data-bs-toggle="modal" data-bs-target="#tempReceivingsModal" data-id="<?php echo $tempReceiving['CartID']; ?>">
                                                            <i class="bi bi-pen-fill"></i>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" id="tempDiscard" type="button" value="<?php echo $tempReceiving['CartID']; ?>">
                                                            <i class="bi bi-trash3-fill"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                        <?php
                                                endforeach;
                                            endif;
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <form method="post" id="recForm" enctype="multipart/form-data"  accept-charset="utf-8">               
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight" style="visibility:hidden;">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <input type="hidden" class="form-control" name="RecCartID"id="RecCartID">
                                            <div class="flex-fill bd-highlight">Receiving Mode </div>
                                            <div class="flex-fill bd-highlight">
                                                <select id="recMode" name="mode" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                                   <option value="1">Receive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="subtitle-line bg-secondary ms-auto me-auto ml-1 mt-2">
                                    <div class="d-flex bd-highlight ">
                                        <div class="flex-fill bd-highlight">Find/Scan Item </div>
                                        <div class="flex-fill bd-highlight">                                      
                                            <select id="dropdown" class="form-select ms-2 py-0 text-primary fw-bold" aria-label="Default select example">
                                                <option selected>Start Typing item's name</option>                                               
                                                <?php
                                                    if ($sources):
                                                    foreach ($sources as $source):
                                                ?>
                                                        <option value="<?php echo $source['ItemID']; ?>"><?php echo $source['ItemID']; ?>-<?php echo $source['ItemName']; ?></option>
                                                <?php
                                                   endforeach;
                                               endif;
                                               ?>
                                            </select>
                                        </div>
                                        <div class="ps-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                <i class="bi bi-upc-scan"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table">
                                <div class="tableFixHead mt-2"> 
                                    <table class="table rounded align-middle" id="viewtable">
                                        <thead class="text-center text-secondary rounded">
                                            <th scope="col" id="itemId">Item Name</th>
                                            <th scope="col">MFD</th>
                                            <th scope="col">EXD</th>
                                            <th scope="col">Cost</th>
                                            <th scope="col">Selling</th>
                                            <th scope="col">Qty</th>
                                            <th scope="col">Unit</th>
                                            <th scope="col">Disc %</th>
                                            <th scope="col">Total</th>
                                            <th scope="col" style="display:none" >ramont</th>
                                            <th class="rounded-end" scope="col">Action</th>
                                        </thead>
                                        <tbody id="table_body" class="text-primary fw-bold">
                                       
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4">                    
                    <div class="linear-bg rounded-15 p-2">
                        <div class="d-flex bd-highlight mb-1">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">Select Supplier (Optional)</div>
                                        <div class="flex-fill bd-highlight">
                                            <select name="supplier" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example" id="supplier">
                                                <?php
                                                    if ($Suppliers):
                                                        foreach ($Suppliers as $Supplier):
                                                ?>
                                                            <option value="<?php echo $Supplier['SupplierID']; ?>"><?php echo $Supplier['SupplierID']; ?>-<?php echo $Supplier['SupplierName']; ?></option>
                                                <?php
                                                        endforeach;
                                                    endif;
                                                ?>
                                            </select>                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Subtotal</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0" ><input type="text" class="mainform" name="subtot"id="subtot"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">Tax:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" value="90" class="mainform" id="stax1" name="tax3" readonly></td>                                        
                                    </tr>                                    
                                    <tr class="mt-3">
                                        <td class="py-0">Discount:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" value="4" id="stax2" name="tax5"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" name="tot" id="tot"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1 mt-3">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Comments</td>
                                        <td class="text-end py-0">
                                            <input type="text" id="rcomment" name="comments" class="mainform">
                                            <?php if($validation->getError('name')) {?>
                                                <div class='alert alert-danger mt-2'>
                                                <?php $error = $validation->getError('comments'); ?>
                                                </div>
                                            <?php }?>                                         
                                        </td>                                        
                                    </tr>                                    
                                </tbody>
                            </table>
                        </div>
                        <div class="flex-fill bd-highlight">
                            <div class="subtitle-line bg-secondary ml-1 mt-3 mb-1 ">
                                <div class="d-flex bd-highlight">
                                    <div class="flex-fill bd-highlight">Payment type</div>
                                    <div class="flex-fill bd-highlight">
                                        <select id="paytype" name="payType" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                            <option value="1">Cash</option>
                                            <option value="2">Credit</option>                                         
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="recMode" id="recMode" class="recModeclass">
                        <input type="hidden" name="userId" value="<?php echo $userinfo->UserID; ?>">                               

                        <div class="d-flex bd-highlight mb-1 mt-2">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" id="recivingDone">
                                                Finish 
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" id="finishlater">
                                                Finish Later
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" id="tempDiscard">
                                                Discard
                                            </button>
                                        </div>                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                   
                </div>
            </div>
        </form>   
    </div>
    
    <div id="Recserialpopupspace"></div>
    
</section>
<?php echo view('includes/footer'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // get all receiving data to edit
            $('#recForm').hide();
            
            const dropdown = document.getElementById('dropdown');
            var tableBody = document.getElementById('table_body');
            const recMode = document.getElementById('recMode');
            var RecDetailHTML = '';
            var RecDataSerialPopup = '';

            //get data from databse and fetch
            $('body').on('click', '#tempReceivingsedit', function(e){
                //e.preventDefault();
                var RecID = $(this).attr('data-id');
                //alert(RecID);
                //console.log(RecID);
                var previous_serial_nos = [];
                $.ajax({
                    url: 'receivingsTempEdit/'+RecID,
                    type: "GET",
                    dataType: 'json',
                    success: function (response) {
                        console.log(response);
                        $('#tempRecTable').hide();
                        $('#recForm').show();
                        $('#RecCartID').val(response.receivingsData.CartID);
                        $('#tempDiscard').val(response.receivingsData.CartID);                        
                        $('#supplier').val(response.receivingsData.SupplierID);
                        $('#subtot').val(response.receivingsData.RNet);
                        $('#tot').val(response.receivingsData.RNetwithtax);
                        $('#rcomment').val(response.receivingsData.RComment);
                        $('#paytype').val(response.receivingsData.RPaymentType);

                        //console.log(response.recSerialData);
                        for(var i = 0; i < response.recDetailData.length; i++){
                            
                            // check with previous serial nos
                            //console.log(response.OriginSerialData[response.recDetailData[i].ItemID]);
                            for(var j = 0; j < response.OriginSerialData[response.recDetailData[i].ItemID].length; j++){
                                //console.log(response.OriginSerialData[response.recDetailData[i].ItemID][j]);
                                previous_serial_nos.push(response.OriginSerialData[response.recDetailData[i].ItemID][j]['serial_number']);
                                if (j === response.OriginSerialData[response.recDetailData[i].ItemID].length - 1) {
                                    // Reset variables for the next loop
                                    var psn_values = previous_serial_nos.join(', '); 
                                    previous_serial_nos = [];
                                }
                            }
                            //console.log(psn_values);

                            //start - generate array with selected values 
                            var serialItems = [];

                            var selectedFields = ['serial_number', 'warranty_period', 'item_status'];

                            for (var z = 0; z < response.recSerialData.length; z++) {
                                if (response.recSerialData[z].item_id === response.recDetailData[i].ItemID) {
                                    serialItems.push(response.recSerialData[z]);
                                }
                            }
                            
                            //console.log(selectedFields);
                            // $.each(response.recSerialData, function(index, item) {
                            //     var nestedObject = {};
                            //     $.each(selectedFields, function(i, field) {
                            //         // Check if the selected field/key exists in the item
                            //         if (field in item) {
                            //             // Add the key-value pair to the keyValueArray                             
                            //             nestedObject[field] = item[field];
                            //         }
                            //     });
                            //     serialItems[index] = nestedObject;
                            //     //console.log(item);
                            // });
                            //console.log(serialItems);
                            var serialString = JSON.stringify(serialItems);
                            var newserialString = serialString.replace(/"/g, "'")
                            
                            //store serial items count seperatly
                            $("#serialitemqty"+response.recDetailData[i].ItemID+"").val(serialItems.length);
                            //end - generate array with selected values 

                            RecDetailHTML += 
                                '<tr id="'+response.recDetailData[i].ItemID+'" class="parent"><td class="nr" style="display:none;">' +response.recDetailData[i].ItemID
                                    + '</td><td id="itemName">'
                                    if(response.recDetailData[i].ItemIsSerialized == '1'){
                                        RecDetailHTML += '<button class="btn linear-bg text-secondary px-2 py-0" id="recserialpop" type="button" data-id="'+response.recDetailData[i].ItemID+'" value="'+response.recDetailData[i].CartID+'" data-bs-toggle="modal" data-bs-target="#item'+response.recDetailData[i].ItemID+'">'+response.recDetailData[i].ItemName+'</button><input type="hidden" class="serialData" id="serialData'+response.recDetailData[i].ItemID+'" value="'+newserialString+'">' 
                                    }else{
                                        RecDetailHTML += response.recDetailData[i].ItemName
                                    }
                            RecDetailHTML  += '<input type="hidden" class="serial" id="serial" value="'+response.recDetailData[i].ItemIsSerialized+'"></td><td>'
                                    + '<input type="date" name="mandate" class="manDate" id="rmanDate" style="width:115px" value="'+response.recDetailData[i].RDMFD+'">'
                                    + '</td><td>'
                                    + '<input type="date" name="expdate" class="expDate" id="rexpDate" style="width:115px" value="'+response.recDetailData[i].RDEXP+'">'
                                    + '</td><td>'
                                    + '<input type="text" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice" style="width:40px" value="'+response.recDetailData[i].RDCostPrice+'">' 
                                    + '</td><td>'
                                    + '<input type="text" name="rItemSellPrice" class="rItemSellPrice" id="rItemSellPrice" style="width:40px" value="'+response.recDetailData[i].RDSellingPrice+'">' 
                                    + '</td><td>' 
                                    + '<input type="text" style="width:25px" name="quantity" class="quantity" id="rItemqty'+response.recDetailData[i].ItemID+'" value="'+response.recDetailData[i].RDQty+'"><input type="hidden" name="serialitemqty" class="serialitemqty" id="serialitemqty'+response.recDetailData[i].ItemID+'">'
                                    + '</td><td>'
                                    + '<select style="width:45px" name="unit" class="unit" id="runit">'
                                    + '<option value="'+response.recDetailData[i].ItemUnit+'">'+response.recDetailData[i].UnitName+'</option>';
                                    $.each(response.recDetailData[i].itemUnits, function (i, item) { 
                                        RecDetailHTML += '<option value="'+item.OtherUnits+'">'+item.UnitName+'</option>'
                                    });
                            RecDetailHTML += '</select>'
                                    + '</td><td>'
                                    + '<input type="text" class="discount" style="width:25px" id="rItemDiscount" value="'+response.recDetailData[i].RDiscount+'">'
                                    + '</td><td>' 
                                    + '<input type="text" id="rtotal" value="'+response.recDetailData[i].RAmount+'" style="width:80px" class="rtotal">'//'+total+'
                                    + '</td><td style="display:none;">'
                                    + '<input type="text" id="totramount" style="width:15px" placeholder="ramount" value="" class="ramount">'//'+ramount+'
                                    + '</td><td>'
                                    + '<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+response.recDetailData[i].ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'                                
                                    + '</td></tr>';
                            if(response.recDetailData[i].ItemIsSerialized == '1'){
                                RecDataSerialPopup += '<form id="serialnoform'+response.recDetailData[i].ItemID+'" method="post" class="fetchform">'
                                + '<div class="modal fade serialmodal" id="item'+response.recDetailData[i].ItemID+'" tabindex="-1" aria-labelledby="serialModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">'
                                    + '<div class="modal-dialog">'
                                        + '<div class="modal-content">'
                                            + '<div class="modal-header linear-bg">'
                                                + '<h5 class="modal-title subtitle-line bg-secondary" id="serialModalLabel">Items Serial Nos</h5>'
                                                + '<button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>'
                                            + '</div>'
                                            + '<div class="modal-body">'
                                                + '<div class="tableFixHead mt-2">'
                                                    +'<input class="form-control" type="hidden" id="psn_values'+response.recDetailData[i].ItemID+'" value="'+psn_values+'">'
                                                    + '<table class="table rounded align-middle editserialtable" id="editserialtable'+response.recDetailData[i].ItemID+'">'
                                                        + '<thead class="text-center text-secondary rounded">'
                                                            + '<th scope="col">Serial Nos</th>'
                                                            + '<th scope="col">Warrenty Period</th>'
                                                            + '<th scope="col">Status</th>'
                                                            + '<th scope="col">Action</th>'
                                                        + '</thead>'
                                                        + '<tbody id="editserialtablebody" class="text-primary fw-bold editserialtablebody">'
                                                        if(response.recSerialData){
                                                            //console.log(response.recSerialData);
                                                            var k = response.recSerialData.length;
                                                            //alert(k);   
                                                            if(k == 0){                                                                
                                                                RecDataSerialPopup += '<tr id="0">'
                                                                            + '<td><input type="text" class="form-control serialno" name="serialno" id="serialno" /></td>'
                                                                            + '<td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td>'
                                                                            + '<td><select class="form-control status" name="status" id="status">'
                                                                                +'<option value="1">New</option>'
                                                                                +'<option value="2">Used</option>'
                                                                                +'<option value="3">Aging</option>'
                                                                                +'<option value="4">Damaged</option>'
                                                                            +'</select></td>'
                                                                            + '<td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id="0"><i class="bi bi bi-trash3-fill"></i></button></td>'
                                                                        + '</tr>'
                                                            }                                                        
                                                            //console.log(k);
                                                            //console.log(response.recSerialData);
                                                            //console.log(serialItems);
                                                            for(var j = 0; j < serialItems.length; j++){
                                                                //console.log(serialItems[j]);
                                                                if (typeof serialItems[j] !== 'undefined' && serialItems[j] !== null && typeof serialItems[j].serial_number !== 'undefined') {
                                                                    RecDataSerialPopup +=  '<tr id='+serialItems[j].id+'><td><input type="text" class="form-control serialno" name="serialno" id="serialno" value="'+serialItems[j].serial_number+'" data-id="'+response.recDetailData[i].ItemID+'"/></td>'
                                                                    + '<td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" value="'+serialItems[j].warranty_period+'"/></td>'
                                                                    + '<td><select class="form-control status" id="status">'
                                                                    if(serialItems[j].item_status == '1'){
                                                                        RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                                                            +'<option value="1" selected>New</option>'
                                                                                            +'<option value="2">Used</option>'
                                                                                            +'<option value="3">Aging</option>'
                                                                                            +'<option value="4">Damaged</option>'
                                                                    }
                                                                    if(serialItems[j].item_status == '2'){
                                                                        RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                                                            +'<option value="1">New</option>'
                                                                                            +'<option value="2" selected>Used</option>'
                                                                                            +'<option value="3">Aging</option>'
                                                                                            +'<option value="4">Damaged</option>'
                                                                    }
                                                                    if(serialItems[j].item_status == '3'){
                                                                        RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                                                            +'<option value="1">New</option>'
                                                                                            +'<option value="2">Used</option>'
                                                                                            +'<option value="3" selected>Aging</option>'
                                                                                            +'<option value="4">Damaged</option>'
                                                                    }
                                                                    if(serialItems[j].item_status == '4'){
                                                                        RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                                                            +'<option value="1">New</option>'
                                                                                            +'<option value="2">Used</option>'
                                                                                            +'<option value="3">Aging</option>'
                                                                                            +'<option value="4" selected>Damaged</option>'
                                                                    }
                                                                    +'</select></td>'
                                                                }
                                                                RecDataSerialPopup += '<td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id='+serialItems[j].id+'><i class="bi bi bi-trash3-fill"></i></button></td></tr>'
                                                            }
                                                            // for(var j = 0; j < k; j++){
                                                            //     //console.log(response.recSerialData[j]);
                                                            //     //console.log(serialItems);
                                                            //     if (typeof response.recSerialData[j] !== 'undefined' && response.recSerialData[j] !== null && typeof response.recSerialData[j].serial_number !== 'undefined') {
                                                            //         RecDataSerialPopup +=  '<tr id='+response.recSerialData[j].id+'><td><input type="text" class="form-control serialno" name="serialno" id="serialno" value="'+response.recSerialData[j].serial_number+'"/></td>'
                                                            //         + '<td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" value="'+response.recSerialData[j].warranty_period+'"/></td>'
                                                            //         + '<td><select class="form-control status" id="status">'
                                                            //         if(response.recSerialData[j].item_status == '1'){
                                                            //             RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                            //                                 +'<option value="1" selected>New</option>'
                                                            //                                 +'<option value="2">Used</option>'
                                                            //                                 +'<option value="3">Aging</option>'
                                                            //                                 +'<option value="4">Damaged</option>'
                                                            //         }
                                                            //         if(response.recSerialData[j].item_status == '2'){
                                                            //             RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                            //                                 +'<option value="1">New</option>'
                                                            //                                 +'<option value="2" selected>Used</option>'
                                                            //                                 +'<option value="3">Aging</option>'
                                                            //                                 +'<option value="4">Damaged</option>'
                                                            //         }
                                                            //         if(response.recSerialData[j].item_status == '3'){
                                                            //             RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                            //                                 +'<option value="1">New</option>'
                                                            //                                 +'<option value="2">Used</option>'
                                                            //                                 +'<option value="3" selected>Aging</option>'
                                                            //                                 +'<option value="4">Damaged</option>'
                                                            //         }
                                                            //         if(response.recSerialData[j].item_status == '4'){
                                                            //             RecDataSerialPopup +='<option value="0">Please select an option</option>'
                                                            //                                 +'<option value="1">New</option>'
                                                            //                                 +'<option value="2">Used</option>'
                                                            //                                 +'<option value="3">Aging</option>'
                                                            //                                 +'<option value="4" selected>Damaged</option>'
                                                            //         }
                                                            //         +'</select></td>'
                                                            //     }
                                                            //     RecDataSerialPopup += '<td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id='+response.recSerialData[j].id+'><i class="bi bi bi-trash3-fill"></i></button></td></tr>'
                                                            // }                                                   
                                                        }
                                        RecDataSerialPopup += '</tbody>'
                                                    + '</table><button type="button" class="btn linear-bg text-secondary" id="editaddserialrow" data-id="'+response.recDetailData[i].ItemID+'"><i class="bi bi-plus-lg fw-bold"></i> Add Row</button>'
                                                + '</div>'
                                            + '</div>'
                                            + '<div class="modal-footer ">'
                                                + '<h6 class="text-danger" id="serialErrorMsg"></h6>'
                                                + '<button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="recserialsubmit" data-id="'+response.recDetailData[i].ItemID+'">Submit</button>'
                                            + '</div>'
                                        + '</div>'
                                    + '</div>'
                                + '</div>'
                            + '</form>';
                            }
                        }
                        $("#table_body").append(RecDetailHTML);
                        $("#Recserialpopupspace").append(RecDataSerialPopup);                        
                        
                        // add new row in serial popup - from database
                        $('body').on('click', '#editaddserialrow', function (e) {
                            e.preventDefault();
                            var edititem = $(this).data('id');
                            var serQty = $('#rItemqty'+edititem+'').val();
                            //alert(edititem);
                            var lastRow = $('#editserialtable'+edititem+' #editserialtablebody tr:last');
                            var inputs = lastRow.find('.serialno');
                            var isValid = true;
                            var row_count = $('#editserialtable'+edititem+' #editserialtablebody tr').length;
                            //console.log(lastRow);
                            
                            // Check if any input field in the last row is empty
                            inputs.each(function() {
                                var value = $(this).val();
                                if (value === '') {
                                    isValid = false;
                                    return false; // Exit the loop early if any input is empty
                                }
                            });

                            if (isValid) {
                                // Add a new row with empty inputs
                                var newRow = $('<tr id='+row_count+'><td><input type="text" class="form-control serialno" name="serialno" id="serialno" data-id="'+edititem+'"/></td><td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td><td><select class="form-control status" name="status" id="status"><option value="1">New</option><option value="2">Used</option><option value="3">Aging</option><option value="4">Damaged</option></select></td><td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id='+row_count+'><i class="bi bi bi-trash3-fill"></i></button></td></tr>');
                                $('#editserialtable'+edititem+' #editserialtablebody').append(newRow);
                                serQty++;                                
                                $("#rItemqty"+edititem+"").val(serQty);
                            } else {
                                // Handle invalid inputs
                                swal.fire({
                                    title: 'Warning',
                                    text: 'Please fill in all fields',
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                });
                                //console.log('Please fill the all fields');
                            }
                        });

                        $('body').on('click', '.deleteRow', function(e){
                            e.preventDefault();
                            var dID = $(this).attr('data-id');
                            //alert(dID);
                            $('.editserialtablebody tr#'+dID+'').remove();
                        });

                        //unique serial nos
                        $("body").on("blur", "#editserialtablebody #serialno", function(e){
                            e.preventDefault();
                            var current_serial_no = $(this).val();
                            var itemID = $(this).data('id');
                            //alert(itemID);
                            var pre_serial_nos = $("#psn_values"+itemID+"").val();
                            //console.log(pre_serial_nos);
                            var pre_serial_nos_paces = pre_serial_nos.replace('/\s/g', '');
                            var pre_serial_array = pre_serial_nos_paces.split(",");
                            console.log(pre_serial_array);

                            var foundValue = pre_serial_array.find(function(element) {
                                return element === current_serial_no;
                            });

                            if (foundValue !== undefined) {
                                swal.fire({
                                    title: 'Warning',
                                    text: 'Serial No alread exisist',
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        $(this).val('');
                                    }
                                });
                            } else {
                                //console.log("The search value was not found in the array.");
                            }
                        });

                        // get values modal to main table
                        $('body').on('click', '#recserialsubmit', function (e) {
                            var serialitemID = $(this).data('id');
                            $('#serialnoform'+serialitemID+' tbody tr').each(function(row, tr){                                    
                                var serialNoInput = $(tr).find('.serialno').val();
                                if(serialNoInput != ''){
                                    e.preventDefault();
                                    //alert(serialsubmititemid);                
                                    //var serialDataArrayName = 'serailizedData' + serialitemID;
                                    var serialDataArrayName = [];
                                    $('#serialnoform'+serialitemID+' tbody tr').each(function(row, tr){   
                                        var serialno = $(tr).find('.serialno').val();
                                        if(serialno != ''){
                                            serialDataArrayName[row] ={
                                                "serial_number" : serialno,
                                                "warranty_period" : $(tr).find('.warrenty').val(),
                                                "item_status" : $(tr).find('.status').val(),
                                            };
                                        }
                                    });
                                    //alert(serialDataArrayName);
                                    //var a = 'serialtext' + serialsubmititemid;
                                    //alert(a);
                                    var serialtext = JSON.stringify(serialDataArrayName);
                                    var replacement = serialtext.replace(/'/g, '"');
                                    
                                    $('#serialData'+serialitemID+'').val(replacement);
                                    //console.log(serialtext);
                                    $('.serialmodal').modal('hide');
                                    $('#serialitemqty'+serialitemID+'').val(serialDataArrayName.length);
                                }else{
                                    e.stopPropagation();
                                    $("#serialErrorMsg").text("Empty fields are there!");
                                }
                            });
                        });
                    },
                    error: function (data) {
                        console.log(data);
                        console.log(data.responseText);
                    }
                });
            });

            $("#dropdown").select2();            
            var selectedOption = '';
            $('#dropdown').on('select2:select', function(e) {
                var selectedOption = e.params.data;                
                var itemId = selectedOption.id;
                var previous_serial_nos = [];
                $.ajax({
                    url: 'receivings_feeditemdata/'+itemId,
                    type: "GET",
                    dataType: 'json',
                    success: function (response) {
                        //console.log(response);
                        var trHTML = '';
                        var serialpopup = '';
                        var total = 0;
                        var ramount = 0;
                        var sum = 0;

                        for(var j = 0; j < response.itemSerials.length; j++){
                            previous_serial_nos.push(response.itemSerials[j]['serial_number']);
                        }
                        var psn_values = previous_serial_nos.join(', ');
                        trHTML += 
                            '<tr id="'+response.items.ItemID+'" class="parent"><td class="nr" style="display:none;">' +response.items.ItemID
                                + '</td><td id="itemName">'
                                if(response.items.ItemIsSerialized == '1'){
                                    trHTML += '<button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#item'+response.items.ItemID+'">'+response.items.ItemName+'</button><input type="hidden" class="serialData" id="serialData'+response.items.ItemID+'">'
                                }else{
                                    trHTML += response.items.ItemName
                                }
                        trHTML  += '<input type="hidden" class="serial" id="serial" value="'+response.items.ItemIsSerialized+'"></td><td>'
                                + '<input type="date" name="mandate" class="manDate" id="rmanDate" style="width:115px">'
                                + '</td><td>'
                                + '<input type="date" name="expdate" class="expDate" id="rexpDate" style="width:115px">'
                                + '</td><td>'
                                if(response.last_cost_price == 0.00){
                                    trHTML += '<input type="text" value="0.00" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice" style="width:40px">'                                    
                                }else{
                                    trHTML += '<input type="text" value="'+response.last_cost_price.purchasing_price+'" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice" style="width:40px">'
                                }
                        trHTML  += '</td><td>'
                                + '<input type="text" value="0.00" name="rItemSellPrice" class="rItemSellPrice" id="rItemSellPrice" style="width:40px">' 
                                + '</td><td>' 
                                + '<input type="text" style="width:25px" name="quantity" class="quantity" id="rItemqty" value="1">'
                                + '</td><td>'
                                + '<select style="width:45px" name="unit" class="unit" id="runit">'
                                + '<option value="'+response.items.ItemUnit+'">'+response.items.UnitName+'</option>';
                                $.each(response.itemUnits, function (i, item) { 
                                    trHTML += '<option value="'+item.OtherUnits+'">'+item.UnitName+'</option>'
                                });
                        trHTML += '</select>'
                                + '</td><td>'
                                + '<input type="text" class="discount" style="width:25px" id="rItemDiscount">'
                                + '</td><td>' 
                                + '<input type="text" id="rtotal" value="'+total+'" style="width:80px" class="rtotal">'
                                + '</td><td style="display:none;">'
                                + '<input type="text" id="totramount" style="width:15px" placeholder="ramount" value="'+ramount+'" class="ramount">'
                                + '</td><td>'
                                + '<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+response.items.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'                                
                                + '</td></tr>';
                        serialpopup += '<form id="serialnoform'+response.items.ItemID+'" method="post" class="selectform">'
                                + '<div class="modal fade serialmodal" id="item'+response.items.ItemID+'" tabindex="-1" aria-labelledby="serialModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">'
                                    + '<div class="modal-dialog">'
                                        + '<div class="modal-content">'
                                            + '<div class="modal-header linear-bg">'
                                                + '<h5 class="modal-title subtitle-line bg-secondary" id="serialModalLabel">Items Serial Nos</h5>'
                                                + '<button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>'
                                            + '</div>'
                                            + '<div class="modal-body">'
                                                + '<div class="tableFixHead mt-2">'
                                                    +'<input class="form-control" type="hidden" id="currentItemID" value="'+response.items.ItemID+'">'
                                                    +'<input class="form-control" type="hidden" id="psn_values'+response.items.ItemID+'" value="'+psn_values+'">'
                                                    + '<table class="table rounded align-middle selectserialtable" id="serialtable" data-id="'+response.items.ItemID+'">'
                                                        + '<thead class="text-center text-secondary rounded">'
                                                            + '<th scope="col">Serial No</th>'
                                                            + '<th scope="col">Warrenty Period</th>'
                                                            + '<th scope="col">Status</th>'
                                                            + '<th scope="col">Action</th>'
                                                        + '</thead>'
                                                        + '<tbody id="serialtablebody" class="text-primary fw-bold choose selectserialtablebody">'
                                                            + '<tr id="0">'
                                                                + '<td><input type="text" class="form-control serialno" name="serialno" id="serialno" /></td>'
                                                                + '<td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td>'
                                                                + '<td><select class="form-control status" name="status" id="status">'
                                                                    +'<option value="1">New</option>'
                                                                    +'<option value="2">Used</option>'
                                                                    +'<option value="3">Aging</option>'
                                                                    +'<option value="4">Damaged</option>'
                                                                +'</select></td>'
                                                                + '<td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id="1"><i class="bi bi bi-trash3-fill"></i></button></td>'
                                                            + '</tr>'
                                                        + '</tbody>'
                                                    + '</table><button type="button" class="btn linear-bg text-secondary" id="selectaddserialrow" data-id="'+response.items.ItemID+'"><i class="bi bi-plus-lg fw-bold"></i></button>'
                                                + '</div>'
                                            + '</div>'
                                            + '<div class="modal-footer ">'
                                                + '<h6 class="text-danger" id="selectserialErrorMsg"></h6>'
                                                + '<button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="selectserialsubmit" data-id="'+response.items.ItemID+'">Submit</button>'
                                            + '</div>'
                                        + '</div>'
                                    + '</div>'
                                + '</div>'
                            + '</form>';

                        $("#table_body").append(trHTML);
                        $("#Recserialpopupspace").append(serialpopup);                        
                        
                        // add new row in serial popup - from dropdown select
                        $('body').on('click', '#selectaddserialrow', function (e) {
                            e.preventDefault();
                            var selectitem = $(this).data('id');
                            //alert(edititem);
                            $('.selectserialtable[data-id="' + selectitem + '"]').each(function() {
                                var tableElement = $(this);
                                //console.log(tableElement);
                                var row_count = $('.selectserialtablebody tr').length;
                                var trElement = $('<tr id='+row_count+'></tr>');
                                var tdElement = $('<td><input type="text" class="form-control serialno" name="serialno" id="serialno" /></td><td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td><td><select class="form-control status" name="status" id="status"><option value="1">New</option><option value="2">Used</option><option value="3">Aging</option><option value="4">Damaged</option></select></td><td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id='+row_count+'><i class="bi bi bi-trash3-fill"></i></button></td>');
                                trElement.append(tdElement);
                                tableElement.append(trElement);
                            });
                        });

                        $('body').on('click', '.deleteRow', function(e){
                            e.preventDefault();
                            var dID = $(this).attr('data-id');
                            //alert(dID);
                            $('.serialtablebody tr#'+dID+'').remove();
                        });

                        $(".rtotal").each(function(){
                            sum += parseInt($(this).closest("tr").find(".rtotal").val());
                            $("#subtot").val(sum);                                                  
                            var netTax= -parseInt($("#stax1").val())+parseInt($("#stax2").val());
                            var tot=parseInt($("#subtot").val())-netTax;
                            $("#tot").val(tot);
                        });

                        $(".ramount").each(function(){
                            ramount += parseInt($(this).closest("tr").find(".ramount").val()); 
                            $("#ramount").val(ramount);
                        });

                        //unique serial nos
                        $("body").on("blur", ".selectform #serialno", function(e){
                            e.preventDefault();
                            var cuurent_serial_no = $(this).val();
                            var cuurent_item_id = $("#currentItemID").val();
                            var pre_serial_nos = $('#psn_values'+cuurent_item_id+'').val();
                            var pre_serial_nos_paces = pre_serial_nos.replace(/\s/g, '');
                            var pre_serial_array = pre_serial_nos_paces.split(",");
                            console.log(pre_serial_array);

                            var foundValue = pre_serial_array.find(function(element) {
                                return element === cuurent_serial_no;
                            });

                            if (foundValue !== undefined) {
                                swal.fire({
                                    title: 'Warning',
                                    text: 'Serial No alread exisist',
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        $(this).val('');
                                    }
                                });
                            } else {
                                console.log("The search value was not found in the array.");
                            }
                        });

                        // get values modal to main table
                        $('body').on('click', '#selectserialsubmit', function (e) {
                            $('#serialnoform'+response.items.ItemID+' tbody tr').each(function(row, tr){                                    
                                var serialNoInput = $(tr).find('.serialno').val();
                                //alert("1");

                                if(serialNoInput != ''){
                                    // console.log(serialNoInput);
                                    e.preventDefault();
                                    serailizedData[row] ={
                                        "serialno" : $(tr).find('.serialno').val(),
                                        "warrenty" : $(tr).find('.warrenty').val(),
                                        "status" : $(tr).find('.status').val(),
                                    };

                                    //console.log(serailizedData);
                                    var serialtext = JSON.stringify(serailizedData);
                                    var replacement = serialtext.replace(/'/g, '"');
                                    $('#serialData'+response.items.ItemID+'').val(replacement);
                                    //console.log(serialtext);
                                    $('.serialmodal').modal('hide');
                                    //store serial items count seperatly
                                    $("#serialitemqty"+response.items.ItemID+"").val(serailizedData.length);
                                }else{
                                    e.stopPropagation();
                                    $("#selectserialErrorMsg").text("Empty fields are there!");
                                }
                            });
                        });
                    },                                  
                    error: function (data) {
                        //console.log('error');
                    }
                });
            });

            //delete receiving record from data table
            $('body').on('click', '#recDel', function () {
                var RecId = $(this).attr('data-id');
                var delVal=parseInt($(this).closest("tr").find(".rtotal").val());
                var totVal=parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
                var subtotVal=parseInt($("#subtot").val());
                var newVal=totVal-delVal;
                var newsubTotVal=subtotVal-delVal;
                //console.log(newVal);
                $("#tot").val(newVal);
                $("#subtot").val(newsubTotVal);
                $(this).closest('tr').remove();           
            });  

            // subtotal, total calculation - on cost price blur
            $('body').on('blur', '#rItemCostPrice', function(e){
                e.preventDefault();
                var rowCount = $("#viewtable tr").length;
                var id = $(this).data('value');
                var total=0;
                var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
                var qty = $(this).closest('tr').find("#rItemqty").val();
                var disc = $(this).closest('tr').find("#rItemDiscount").val();
                // alert(costprice);
                // alert(qty);
                // alert(disc);
                var ramount = costprice*qty;
                if(disc){
                    var total = ramount - (ramount * (disc/100));
                    $(this).closest('tr').find('#rtotal').val(parseInt(total));
                }else{                    
                    $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
                }

                var sum = 0;
                $(".rtotal").each(function(){
                    sum += parseInt($(this).closest("tr").find(".rtotal").val());
                    $("#subtot").val(sum);  
                    //console.log(sum);                                                
                    var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                    var tot = parseInt($("#subtot").val()) - netTax;
                    $("#tot").val(tot);
                });
            });

            // subtotal, total calculation - on qty blur
            $('body').on('blur', '#rItemqty', function(e){
                e.preventDefault();
                var rowCount = $("#viewtable tr").length;
                var id = $(this).data('value');
                var total=0;
                var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
                var qty = $(this).closest('tr').find("#rItemqty").val();
                var disc = $(this).closest('tr').find("#rItemDiscount").val();
                // alert(costprice);
                // alert(qty);
                // alert(disc);
                var ramount = costprice*qty;
                if(disc){
                    var total = ramount - (ramount * (disc/100));
                    $(this).closest('tr').find('#rtotal').val(parseInt(total));
                }else{                    
                    $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
                }

                var sum = 0;
                $(".rtotal").each(function(){
                    sum += parseInt($(this).closest("tr").find(".rtotal").val());
                    $("#subtot").val(sum);  
                    //console.log(sum);                                                
                    var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                    var tot = parseInt($("#subtot").val()) - netTax;
                    $("#tot").val(tot);
                });
            });

            // subtotal, total calculation - on discount blur
            $('body').on('blur', '#rItemDiscount', function(e){
                e.preventDefault();
                var rowCount = $("#viewtable tr").length;
                var id = $(this).data('value');
                var total=0;
                var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
                var qty = $(this).closest('tr').find("#rItemqty").val();
                var disc = $(this).closest('tr').find("#rItemDiscount").val();
                // alert(costprice);
                // alert(qty);
                // alert(disc);
                var ramount = costprice*qty;
                if(disc){
                    var total = ramount - (ramount * (disc/100));
                    $(this).closest('tr').find('#rtotal').val(parseInt(total));
                }else{                    
                    $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
                }

                var sum = 0;
                $(".rtotal").each(function(){
                    sum += parseInt($(this).closest("tr").find(".rtotal").val());
                    $("#subtot").val(sum);  
                    //console.log(sum);                                                
                    var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                    var tot = parseInt($("#subtot").val()) - netTax;
                    $("#tot").val(tot);
                });
            });

            //delete receiving record from data table
            $('body').on('click', '#recDel', function () {
                var RecId = $(this).attr('data-id');
                var delVal=parseInt($(this).closest("tr").find(".rtotal").val());
                var totVal=parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
                var subtotVal=parseInt($("#subtot").val());
                var newVal=totVal-delVal;
                var newsubTotVal=subtotVal-delVal;
                //console.log(newVal);
                $("#tot").val(newVal);
                $("#subtot").val(newsubTotVal);
                $(this).closest('tr').remove();           
            });

            //validations
            var valid = '';
            var pricevalid = '';
            var emptyvalid = '';

            //Serial Item Qty and Total Qty Validation Check
            function validateSerialQty(serialItem, totQty) {
                if(serialItem != 0 && totQty != 0){                
                    if (serialItem != totQty) {
                        valid = false;
                        swal.fire({
                            title: 'Warning',
                            text: 'No of Serial data not match to given Qty',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        });
                    } else {
                        valid = true;
                    }
                }else{
                    if(serialItem == 0){
                        valid = false;
                        swal.fire({
                            title: 'Warning',
                            text: 'Serial Items not entered yet',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        });
                    }
                    
                    if(totQty == 0){
                        valid = false;
                        swal.fire({
                            title: 'Warning',
                            text: 'Serial Items not entered yet',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        });
                    }
                }
            }
        
            //Cost Price empty checking
            function emptyCostPriceCheck(costPrice){
                if(costPrice == 0.00 || costPrice == '0.00' || costPrice == '0'){
                    pricevalid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please check the Cost Price & Selling Price",
                        icon: 'error'
                    });
                }else{
                    pricevalid = true;
                }
            }

            //empty check validations - supplier
            function supplierEmptyCheck(){
                var supplierData = $("#supplier").val();

                if(supplierData == ''){
                    emptyvalid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please select the Supplier",
                        icon: 'error'
                    });
                }else{
                    emptyvalid = true;
                }
            }

            //empty check validations - sub total
            function subTotalEmptyCheck(){
                var subTotal = $("#subtot").val();

                if(subTotal == '' || subTotal == '0.00'){
                    emptyvalid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please check the Sub Total",
                        icon: 'error'
                    });
                }else{
                    emptyvalid = true;
                }
            }
        
            //empty check validations - total
            function totalEmptyCheck(){
                var Total = $("#tot").val();

                if(Total == '' || Total == '0.00'){
                    emptyvalid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please check the Total",
                        icon: 'error'
                    });
                }else{
                    emptyvalid = true;
                }
            }

            //empty check validations - Payment Type
            function payTypeEmptyCheck(){
                var payType = $("#paytype").val();

                if(payType == '' || payType == '0'){
                    emptyvalid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please select the Payment Type",
                        icon: 'error'
                    });
                }else{
                    emptyvalid = true;
                }
            }
        
            //empty check validations - serial data
            function serialDataEmptyCheck(){
                $('#viewtable tbody tr[class="parent"]').each(function(row, tr){
                    var isSerialData = $(tr).find('.serialData').val();
                    if(isSerialData == ''){
                        valid = false;
                        swal.fire({
                            title: 'Empty field Detected',
                            text: "Please check the Serial Nos",
                            icon: 'error'
                        });
                    }else{
                        valid = true;
                    }
                });
            }

            //Total Qty blur validation
            $('body').on('blur', '#rItemqty', function(){
                $('#viewtable tbody tr[class="parent"]').each(function(row, tr){
                    var isSerial = $(tr).find('.serial').val();            
                    var serialCounts = $(tr).find('.serialitemqty').val();
                    //alert(serialCounts);
                    var totQty = $(tr).find('.quantity').val();
                    //alert(totQty);
                    //alert(serialCounts);
                    if(isSerial != '0'){
                        validateSerialQty(serialCounts, totQty);
                    }
                });
            });

            var tableData = [];
            var serialData = '';

            // save temp data to origin and delete temp data
            $('body').on('click', '#recivingDone', function(e) {
                e.preventDefault();
                $('#viewtable tbody tr[class="parent"]').each(function(row, tr){ 
                    var hasserial = $(tr).find('.serial').val();
                    //alert(hasserial);                    

                    //Cost Price Validation
                    var costP = $(this).find(".rItemCostPrice").val();
                    emptyCostPriceCheck(costP);

                    //Serial Item Qty & Total Qty Validation
                    var totQty = $(tr).find('.quantity').val(); 
                    var serialCounts = $(tr).find('.serialitemqty').val();
                    // alert(totQty);
                    // alert(totQty);
                    validateSerialQty(serialCounts, totQty);
                    
                    //empty check validation
                    supplierEmptyCheck();
                    subTotalEmptyCheck();
                    totalEmptyCheck();
                    payTypeEmptyCheck();
                    //serialDataEmptyCheck();

                    if($(tr).find('.serial').val() == '1'){
                        serialData = $(tr).find('.serialData').val();
                    }else{                    
                        serialData = '';
                    }
                    tableData[row] ={
                        "serialData" : serialData,
                        "itemid" : $(tr).find('td:eq(0)').text(),
                        "name" : $(tr).find('td:eq(1)').text(),
                        "serialized" : $(tr).find('.serial').val(),
                        "expDate" : $(tr).find('.expDate').val(),
                        "manDate" : $(tr).find('.manDate').val(),
                        "price" : $(tr).find('.rItemCostPrice').val(),
                        "sellprice" : $(tr).find('.rItemSellPrice').val(),
                        "qty" : $(tr).find('.quantity').val(),
                        "unit" : $(tr).find('.unit').val(),
                        "ramount" : $(tr).find('.rtotal').val(),
                        "disc" : $(tr).find('.discount').val(),
                    };
                });
                
                var frmData = $("#recForm").serialize();
                
                // console.log(tableData);
                // console.log(frmData);
                //alert(valid);
                if(valid && pricevalid && emptyvalid){
                    //if(tableData != ''){
                        $.ajax({
                            url: '/receivingsTempSaveFromTemp',
                            type: "POST",
                            data: { 
                                tableData: tableData,
                                frmData:frmData,
                            },
                            //dataType: "json",
                            success: function(response) {
                                console.log(response);
                                swal.fire({
                                    title: response.title,
                                    text: response.text,
                                    icon: 'success',
                                    showCancelButton: true,
                                    confirmButtonText: 'View',
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    window.open('/receivings_view/'+rec_id, '_blank');
                                }
                                else{
                                    window.location.href = '/receivingsTempList'
                                }
                            });
                            },
                            error: function(xhr) {
                                console.error('Error saving table data:', xhr.responseText);
                            }
                        });
                    //}else{                        
                        // swal.fire({
                        //     title: 'Empty field Detected',
                        //     text: "Please check serial items",
                        //     icon: 'error'
                        // });
                    //}
                }
            });

            // pass data to temproary table
            $('body').on('click', '#finishlater', function(e) {
                e.preventDefault();
                $('#viewtable tbody tr[class="parent"]').each(function(row, tr){ 
                    var hasserial = $(tr).find('.serial').val();
                    //alert(hasserial);
                    if(hasserial == '1'){ 
                        tableData[row] ={
                            "id" : $(tr).find('td:eq(0)').text(),
                            "name" : $(tr).find('td:eq(1)').text(),
                            "serialized" : $(tr).find('.serial').val(),
                            "expDate" : $(tr).find('.expDate').val(),
                            "manDate" : $(tr).find('.manDate').val(),
                            "serialData" : $(tr).find('.serialData').val(),
                            "price" : $(tr).find('.rItemCostPrice').val(),
                            "sellprice" : $(tr).find('.rItemSellPrice').val(),
                            "qty" : $(tr).find('.quantity').val(),
                            "unit" : $(tr).find('.unit').val(),
                            "ramount" : $(tr).find('.rtotal').val(),
                            "disc" : $(tr).find('.discount').val(),
                        };
                    }else{
                        tableData[row] ={
                            "id" : $(tr).find('td:eq(0)').text(),
                            "name" : $(tr).find('td:eq(1)').text(),
                            "serialized" : $(tr).find('.serial').val(),
                            "expDate" : $(tr).find('.expDate').val(),
                            "manDate" : $(tr).find('.manDate').val(),
                            "price" : $(tr).find('.rItemCostPrice').val(),
                            "sellprice" : $(tr).find('.rItemSellPrice').val(),
                            "qty" : $(tr).find('.quantity').val(),
                            "unit" : $(tr).find('.unit').val(),
                            "ramount" : $(tr).find('.rtotal').val(),
                            "disc" : $(tr).find('.discount').val(),
                        }; 
                    } 
                });
                
                var frmData = $("#recForm").serialize();
                // console.log(tableData);

                $.ajax({
                    // alert(rowData);
                    url: '/receivingsUpdateTemp',
                    type: "POST",
                    data: { 
                        tableData: tableData,
                        frmData:frmData,
                        //groupedSerialData:groupedSerialData,
                    },
                    //dataType: "json",
                    success: function(response) {
                        //console.log(frm_data);
                        console.log(response);
                        swal.fire({
                            title: response.title,
                            text: response.text,
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = '/receivingsTempList'
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error saving table data:', xhr.responseText);
                        console.error(xhr);
                        console.error(status);
                        console.error(error);
                        //console.log(frm_data);
                        if(xhr.statusText == 'Internal Server Error'){
                            var eMessage = 'Internal Server Error'
                        }
                        swal.fire({
                            title: 'Error',
                            text: eMessage  ,
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        });
                    }
                });
            });

            $("body").on("change", "#rmanDate", function () {
                var myDate = new Date($(this).val());
                var d = new Date(myDate),
                    month = '' + (d.getMonth() + 1),
                    day = '' + d.getDate(),
                    year = d.getFullYear();

                if (month.length < 2) month = '0'+ month;
                if (day.length < 2) day = '0'+day;

                var minDate = [year, month, day].join('-');
                //alert(minDate);
                $("#rexpDate").attr('min',minDate);
            });

            $("body").on("click", "#tempDiscard", function(e){
                e.preventDefault();
                var CartID = $(this).val();
                swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, discard it!',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '/receivingsTempDiscardData',
                            type: "POST",
                            data: { 
                                CartID: CartID,
                            },
                            success: function(response) {
                                //console.log(frm_data);
                                console.log(response);
                                swal.fire({
                                    title: response.title,
                                    text: response.text,
                                    icon: 'success',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        window.location.href = '/receivingsTempList'
                                    }
                                });
                            },
                            error: function(xhr, status, error) {
                                console.error('Error saving table data:', xhr.responseText);
                                console.error(xhr);
                                console.error(status);
                                console.error(error);
                                //console.log(frm_data);
                            }
                        });
                    }
                });         
            });
        });
    </script>
<?php $this->endSection() ?>