<?php $this->extend('layouts/master') ?>

<?php $this->section('locations') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <!-- <div class="flex-fill bd-highlight">Delete</div> -->
                                            <!--div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </div-->
                                            <!-- <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">Email</div> -->
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <!-- <button class="btn linear-bg text-secondary px-2 py-0" type="button"><i class="bi bi-search"></i></button> -->
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <?php
                                                        if($storingtypes):
                                                    ?>
                                                        <?php if($storingtypes == 'Location'):?>
                                                           
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#locationModal">
                                                            <a href="/conversion_factor" class="text-secondary text-decoration-none">    
                                                             Add Conversion Factor
                                                        </a>New Location <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                        <?php endif ?>
                                                        <?php if($storingtypes == 'Bin'):?>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" >
                                                                <a href="/locationsview" class="text-secondary text-decoration-none">    
                                                                     New Location
                                                                </a> 
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#itemBinsModal">
                                                            New Location Bin <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                        <?php endif ?>
                                                        <?php if($storingtypes == 'Standard'):?>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                            New Warehouse <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                            New Zone <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                            New Aisie <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                            New Rack <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                            New Shelf <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#binModal">
                                                            New Bin <i class="bi bi-plus-lg fw-bold"></i>
                                                            </button>
                                                        <?php endif ?>
                                                    <?php
                                                        endif;
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                           <th class="p-2" scope="col">Location </th>
                                            <th class="p-2" scope="col">Item  Name</th>
                                            <th class="p-2" scope="col">Batch No</th>
                                            <th class="p-2" scope="col">Qty Level</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                                       
                                               <?php 
                                                    if($sources):
                                                    foreach($sources as $source): 
                                                    foreach($source as $s): 
                                                ?>
                                                <tr id="<?php echo $s['ILID']; ?>">
                                                    <td><?php echo $s['LocationName']; ?></td>  
                                                    <td><?php echo $s['ItemName']; ?></td>   
                                                    <td><?php echo $s['BatchNo']; ?></td>
                                                    <td><?php echo $s['ILQtyLevel']; ?></td>
                                                    <td>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" id="locationbinedit" type="button" data-bs-toggle="modal" data-bs-target="#itemBinsModal" data-id="<?php echo $s['ILID']; ?>">
                                                            <i class="bi bi-pen-fill"></i>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" id="locationbindelete" type="button" data-id="<?php echo $s['ILID']; ?>">
                                                            <i class="bi bi-trash3-fill"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php
                                                    endforeach;
                                                    endforeach;
                                                    endif;
                                                ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--- Item Location Bins Start --->
        <div class="modal fade" id="itemBinsModal" tabindex="-1" aria-labelledby="itemBinsModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="itemBinsModalLabel">Location Bins</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">                            
                            <div class="mb-3" id="additemBins">
                                <form action="/bin_insert" method="post" accept-charset="utf-8" id="locationform">
                                    <input type="hidden" class="form-control mb-3" value="<?php echo set_value('itemBinId');?>" name="itemBinId" id="itemBinId">
                                    <label  for="itemBinLocationId"> Select Item Location:</label>
                                    <select class="form-control mb-3" name="itemBinLocationId" id="itemBinLocationId">
                                        <option value="">Please select an option</option>
                                        <?php 
                                            if($locations):
                                            foreach($locations as $location):                                          
                                        ?>
                                        <option value="<?php echo $location['LocationID']; ?>" <?php echo set_value('itemBinLocationId') == $location['LocationID'] ? 'selected' : ''; ?> >
                                           <?php echo $location['LocationName']; ?></option>   
                                        <?php
                                            endforeach;
                                            endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'itemBinLocationId') : '' ?></h6>

                                    <label  for="itemBinLocatonName"id="itemBinName" > Enter Item Bin Name:</label>
                                    <input type="text" class="form-control mb-3" name="itemBinName"  value="<?php echo set_value('itemBinName');?>"   id="itemBinName" placeholder="Enter Item Bin Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'itemBinName') : '' ?></h6>

                                    <label  for="IBItem"> Select an Item :</label>
                                    <select class="form-control mb-3" name="IBItem" id="IBItem">
                                        <option value="">Please select an item</option>
                                        <?php 
                                            if($Items):
                                            foreach($Items as $Item):                                          
                                        ?>
                                        <option value="<?php echo $Item['ItemID']; ?>" <?php echo set_value('IBItem') == $Item['ItemID'] ? 'selected' : ''; ?> >
                                           <?php echo $Item['ItemName']; ?></option>   
                                        <?php
                                            endforeach;
                                            endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'IBItem') : '' ?></h6>

                                    <label  for="IBBatchNo"> Batch No:</label>
                                    <input type="text" class="form-control mb-3" value="<?php echo set_value('IBBatchNo');?>" name="IBBatchNo" id="IBBatchNo" placeholder="Enter Batch No">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'IBBatchNo') : '' ?></h6>

                                    <label  for="IBQtyLevel"> Enter Bin Space:</label>
                                    <input type="text" class="form-control mb-3 disableletter"  value="<?php echo set_value('IBQtyLevel');?>" name="IBQtyLevel" id="IBQtyLevel" placeholder="Enter Bin Space">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'IBQtyLevel') : '' ?></h6>

                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                                </form>         
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Item Location Bins End --->
        <!--- Bin End --->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>   
     <script>
                   
        function bin_location_insert_modal (){
            var bin_location_insert_modal = $("#itemBinsModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                bin_location_insert_modal.modal('show');
            }
        }
        // function openLocationInsertModal(){
        //     var insert_modaopenBinLocationInsertModall = $("#locationModal");
        //     var has_errors = $("#has_errors").val();
        //     if(has_errors == 'true'){
        //         insert_modal.modal('show');
        //     }
        // }
        // function openBinInsertModal(){
        //     var insert_modal = $("#itemBinsModal");
        //     var has_errors = $("#has_errors").val();
        //     if(has_errors == 'true'){
        //         insert_modal.modal('show');
        //     }
        // }
        $(document).ready(function() {
            bin_location_insert_modal();
           
            $('#viewtable, #itemlocationtable, #itembinlocationtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });

            EmpTable = $('#viewtable, #itemlocationtable, #itembinlocationtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });
        
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        
        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }

        //update locations bin
        $('body').on('click', '#locationbinedit', function () {
            var itemlocationid = $(this).attr('data-id');
            $.ajax({
                url: 'location_bin_single_data/'+itemlocationid,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res.data);
                    $('#itemBinsModal').modal('show');
                    $('#locationform #itemBinId').val(res.data.ILID); 
                    $('#locationform #itemBinLocationId').val(res.data.LocationID);
                    $('#locationform #itemBinName').hide();
                    $('#locationform #IBItem').val(res.data.ItemID);
                    $('#locationform #IBBatchNo').val(res.data.BatchNo);
                    $('#locationform #IBQtyLevel').val(res.data.ILQtyLevel);
                },
                    error: function (data) {
                        console.log('error');
                      
                }
            });
        });

        //delete locations
        $('body').on('click', '#locationdelete', function () {
            var locid = $(this).attr('data-id');
            $.get('/delete_location/'+locid, function (data) {
                $('#itemlocationtable #'+ locid).remove();
            });
        });

        //update itembins
        $('body').on('click', '#binedit', function () {
            var binlocationid = $(this).attr('data-id');
            $.ajax({
                url: 'bin_single_data/'+binlocationid,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#itemBinsModal').modal('show');
                    $('#itemBinId').val(res.data.ILID); 
                    $('#itemBinLocationId').val(res.data.ILID); 
                    $('#itemBinLocatonName').val(res.data.IBName);
                    $('#IBItem').val(res.data.ItemID);
                    $('#IBBatchNo').val(res.data.BatchNo);
                    $('#IBQtyLevel').val(res.data.IBQtyLevel);
                },
                    error: function (data) {
                }
            });
        });

        //delete itembins
        $('body').on('click', '#bindelete', function () {
            var binlocationid = $(this).attr('data-id');
            $.get('bin_delete/'+binlocationid, function (data) {
                $('#viewtable #'+ binlocationid).remove();
            });
        });

         //delete locations
         $('body').on('click', '#locationbindelete', function () {
            var binlocationid = $(this).attr('data-id');
            // alert(binlocationid);
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ binlocationid).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: '/location_bin_delete/'+binlocationid,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ binlocationid).remove();
                            }
                        }
                    });
                }
            });          
        });


        //set batch number based on selected item
        $('#IBItem').change(function() {
                // Get the selected option value
                var itemID = $(this).val();
                $.ajax({
                    url: 'single_stock_data/'+itemID ,
                    type: "GET",
                    dataType: 'json',
                    success: function (res) {
                        console.log(res.data);
                        $('#itemBinsModal').modal('show');
                            $('#locationform #IBBatchNo').val(res.data.BatchNo);                                                    
                },
                    error: function (data) {
                }
            });
            $('#locationform #IBBatchNo').val('No Batch Number');  
        });

         //reset form
         $('#itemBinsModal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

               // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submitBtn').disabled = true;
        });
    </script>
<?php $this->endSection() ?>