<?php $this->extend('layouts/master') ?>

<?php $this->section('discount_type') ?>

        <!---List of discount types  --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                                <div class="flex-fill bd-highlight">
                                                    <div class="ms-2 py-0 text-primary fw-bold">
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#discountTypeModal"><i class="bi bi-plus-lg fw-bold"></i> New Discount Type </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Discount Types</th>
                                            <!-- <th class="p-2" scope="col">Status</th> -->
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                        <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                                
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">     
                                                <td><?php echo $s['discount_type']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['id']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['id']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="discountTypeedit" type="button" data-bs-toggle="modal" data-bs-target="#discountTypeModal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="discountTypedelete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start  user role insert and update model  -->
        <div class="modal fade" id="discountTypeModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> Discount Type Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="discountType" name="discountType" action="<?= site_url('/submit_discount_type') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                   <label for="dtype" class="col-form-label">Enter Discount Type:</label>
                                   <input class="form-control" name="id" id="id" hidden  value="<?php echo set_value('id');?>">
                                    <input type="text" class="form-control" name="discount_type" id="discount_type" placeholder="Enter Discount Type">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'discount_type') : '' ?></h6>
                                </div>
                            </div>                   
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold"  id="submit" >Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!---End  user role insert and update model ---> 
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openDiscountTypeModal()
        {
                var discount_type_modal = $("#discountTypeModal");
                var has_errors = $("#has_errors").val();
                if(has_errors == 'true'){
                    discount_type_modal.modal('show');
                }
        }
        $(document).ready(function() 
        {
                openDiscountTypeModal();
                $('#viewtable').DataTable( {
                    dom: 'Bfrtip',
                    buttons: [
                        { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                        { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                        { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                        { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                    ],                        
                    info: false,
                    select: {
                        style:    'multi',
                        selector: 'td:first-child'
                    },                        
                    columnDefs: [ {
                        orderable: false,
                        className: 'select-checkbox',
                        targets:   0
                    } ],
                });
                URTable = $('#viewtable').DataTable();
                $('#vtSearch').keyup(function(){
                    URTable.search($(this).val()).draw() ;
                });
                $(".selectAll").on( "click", function(e) {
                    if ($(this).is( ":checked" )) {
                        URTable.rows().select();        
                    } else {
                        URTable.rows().deselect(); 
                    }
                });
                $.extend( DataTable.ext.classes, {
                    "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                    "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                    "sFilter": "dnone",
                });
        });
        //Check All
        function checkAll(o) 
        {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
        //update discount type
        $('body').on('click', '#discountTypeedit', function () 
        {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'discount_type_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#discountTypeModal').modal('show');
                    $('#discountType #id').val(res.data.id); 
                    $('#discountType #discount_type').val(res.data.discount_type); 
                },
                    error: function (data) {
                }
            });
        });
        //delete urole
        $('body').on('click', '#discountTypedelete', function () 
        {
                var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ id).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: '/discount_type_delete/'+id,
                        async: false,
                        success: function(data){  
                            location.reload()                         
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ id).remove();
                            }
                        }
                    });
                }
            });          
        });
         //discount type disable
        $('body').on('change', '#disable', function () 
        {
                var id = $(this).attr('data-id');
                //  alert(id);
                $.getJSON('enable_discount_type/'+id, function (data) {                
                location.reload();
                        })
        });
        //discount type enable
        $('body').on('change', '#enable', function () 
        {
                var id = $(this).attr('data-id');
                $.getJSON('disable_discount_type/'+id, function (data) {
                    location.reload();
                })
        });
        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() 
        {
            document.querySelector('#submit').disabled = true;
        });
                    
    </script>
<?php $this->endSection() ?>