<?php

    namespace App\Models;

    use CodeIgniter\Model;

    class UserModel extends Model{

        protected $table      = 'user';
        protected $primaryKey = 'UserID';

        protected $useAutoIncrement = true;

        protected $returnType     = 'array';
        protected $useSoftDeletes = false;

        protected $allowedFields = ['UserID', 'EmpID', 'UserRole', 'UserName', 'UserPassword','AuthKey', 'UserCreatedAt', 'UserCreatedBy', 'UserUpdatedAt', 'UserUpdatedBy','UserDeletedAt', 'UserDeletedBy', 'delete_flag','current_status'];
        
        // Dates
        protected $useTimestamps = false;
        protected $dateFormat    = 'datetime';
        protected $createdField  = 'UserCreatedAt';
        protected $updatedField  = 'UserUpdatedAt';
        protected $deletedField  = 'UserDeletedAt';

        // Validation
        protected $validationRules      = [];
        protected $validationMessages   = [];
        protected $skipValidation       = false;
        protected $cleanValidationRules = true;

        // Callbacks
        protected $allowCallbacks = true;
        protected $beforeInsert   = [];
        protected $afterInsert    = [];
        protected $beforeUpdate   = [];
        protected $afterUpdate    = [];
        protected $beforeFind     = [];
        protected $afterFind      = [];
        protected $beforeDelete   = [];
        protected $afterDelete    = [];
        // get user data
        public function getUserData()
        {
            $data= $this->db
                ->table('user')
                ->where('delete_flag', '0')
                ->orWhere('current_status', '1')
                ->orderBy('UserID', 'ASC')
                ->get()
                ->getResultArray();
            return $data;
        }
        // get all user active data
        public function getActiveUserData()
        {
            $data= $this->db
                ->table('user')
                ->where('delete_flag', '0')
                ->Where('current_status', '1')
                ->orderBy('UserID', 'ASC')
                ->get()
                ->getResultArray();
            return $data;
        }
        // insert user data
        function insertUserData($data)
        {
            return $this->db
                    ->table('user')
                    ->insert($data);
        }
        // get employee data
        function getSingleEmpData($id)
        {
            $data= $this->db 
            ->table('user')
            ->where('user.EmpID', $id)
            ->get()
            ->getRow();
            return $data;
        
        }    
        public function check($username, $password)
        {
            // Get the user data from the database
            $user = $this->where('UserName', $username)->first();
            // Check if the user exists
            if ($user) {
                // Verify the password
                if ($user['UserPassword'] === $password) {
                    return $user;
                }
            }
            return false;
        }
        // get single user data
        function getSingleUserData($id)
        {
            return $this->db
                ->table('user')
                ->where(["UserID" => $id])
                ->get()
                ->getRow();
        }
        function getUserEmployeeJoinData($id)
        {
         return $this->db
                ->table('user')
                ->where(["user.EmpID", $id])
                ->join('employee', 'employee.EmpID= user.EmpID')
                ->get()
                ->getRow();             
        }
        // get  user data when update employee
        function updateUser($data,$id,$eid)
        {    
                return $this->db
                    ->table('user')
                    ->where(['UserID'=> $id])
                    ->where(['EmpID'=> $eid])
                    ->set($data)
                    ->update();    
        }
        // delete employee
        function deleteUser($id,$data)
        { 
                return $this->db
                ->table('user')
                ->where(["UserID" => $id])
                ->set($data)
                ->update();
        }
        public function ModifySaleCheckAuthorization($auth_key)
        {
            $user_auth_data = $this->db->table('user')->select('AuthKey,UserID')->where(["AuthKey" => $auth_key])->where(["UserRole" => 3])->get()->getRow();
            if($user_auth_data != null){
                $authoriz_data['authorized_by'] = $user_auth_data->UserID;
                $authoriz_data['is_authorized'] = true;
            }
            else{
                $authoriz_data['authorized_by'] = 0;
                $authoriz_data['is_authorized'] = false;
            }
            return $authoriz_data;
        }
        // user status  change
        function statusupdate($id,$data)
        {
            return $this->db
                ->table('user')
                ->where(["UserID" => $id])
                ->set($data)
                ->update();
        }
        
    }

?>