<?php

namespace App\Models;

use CodeIgniter\Model;

class ConversionFactorModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'conversionfactors';
    protected $primaryKey       = 'CFID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['FromUnitiD', 'ToUnitID', 'CFFactor', 'CFCreatedAt', 'CFUpdatedAt','CFDeletedAt','delete_flag', 'current_status','CFCreatedBy','CFUpdatedBy','CFDeletedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'CFCreatedAt';
    protected $updatedField  = 'CFUpdatedAt';
    protected $deletedField  = 'CFDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all CFs data    
    function getAllCFsData()
    {
        return $this->db
            ->table('conversionfactor')
            //->join('units','conversionfactor.FromUnitiD = units.UnitID OR conversionfactor.ToUnitID = units.UnitID')
            ->where('delete_flag', '0')
            ->orderBy('CFID ', 'ASC')
            ->get()
            ->getResultArray();
    }

    // save CFs data
    function insertCFs($data)
	{   
        return $this->db
            ->table('conversionfactor')
            ->insert($data);
	}

    // get single CF data
    function getSingleCFData($id)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->get()
            ->getRow();
    }

    // update Cfs data
    function updateCFs($id, $data)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->set($data)
            ->update();
    }

    // delete CF
    function deleteCFs($id,$data)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->set($data)
            ->update();
    }

    // find duplicate values   
    function checkData($cfToUnit,$cfFromUnit)
    {
        return $this->db
            ->table('conversionfactor')
            ->where([
                'FromUnitiD' => $cfFromUnit,
                'ToUnitID' => $cfToUnit
            ])
            //->where('ToUnitID', $cfToUnit)
            ->get()
            ->getRow();
    }

    //  status  change
    function statusupdate($id,$data)
    {
        return $this->db
            ->table('conversionfactor')
            ->where(["CFID" => $id])
            ->set($data)
            ->update();
    }

    //get convertion factor
    function getConvertionRate($cfToUnit,$cfFromUnit)
    {
        return $this->db
            ->table('conversionfactor')
            ->where([
                'FromUnitiD' => $cfFromUnit,
                'ToUnitID' => $cfToUnit
            ])
            ->get()
            ->getResult();
    }
}
