<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Sales extends Migration
{
    public function up()
    {
        //Create Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'pos_id' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'user_id' => [
                'type' => 'INT',
            ],
            'customer_id' => [
                'type' => 'INT',
            ],
            'sale_type_id' => [
                'type' => 'INT',
                'constraint' => 1,
                'comment' => 'cash: 1, credit: 2',
            ],
            'total_amount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'discount_amount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('sales');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('sales');
    }
}
