<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ConversionFactor extends Migration
{
    public function up()
    {
        //Create Conversion Factor Table
        $this->forge->addField([
            'CFID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'FromUnitiD' => [
                'type'=> 'varchar',
                'constraint' => 255,
            ],
            'ToUnitID' => [
                'type'=> 'varchar',
                'constraint' => 255,
            ],
            'CFFactor' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'CFCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'CFUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'CFDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('CFID');
        $this->forge->createTable('conversionfactor');
    }

    public function down()
    {
        //Drop Conversion Factor Table
        $this->forge->dropTable('conversionfactor');
    }
}
