<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemLocations extends Migration
{
    public function up()
    {
        //Create ItemLocations Table
        $this->forge->addField([
            'ILID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'LocationID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BatchNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ILQtyLevel' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ILCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ILUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ILDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ILDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'ILStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('ILID');
        $this->forge->createTable('itemlocations');
    }

    public function down()
    {
        //Drop ItemLocations Table
        $this->forge->dropTable('itemlocations');
    }
}
