<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomerContactInformationModel;
use App\Models\CustomerModel;
use App\Models\CommonModel;

class CustomerContactInformationController extends BaseController
{
    //construct function
    public function __construct(){
        $this->customer_contact_information = new CustomerContactInformationModel();   
        $this->customer = new CustomerModel();   
        $this->common = new CommonModel();                        
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit()
     {
        $user_info = getUserInfo();   
        $validation = $this->validate([
            'customer_id' => [
                'rules'=>'required|greater_than[0]',
                'errors'=>[
                    'required'=>'Please select customer',
                    'greater_than'=>'Please select customer',
                ],
            ],
            'address' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter address',
                ],
            ],
            'phone_number' => [
                'rules'=>[
                    'required',
                    //'regex_match[^(?:(?:\+|00)1)?(?:\d{3}[.-]?\d{3}[.-]?\d{4}|\(\d{3}\)\s*\d{3}[-.]?\d{4}|(?:\d{4}|\d{3})[-.]?\d{4})$]'
                ],
                'errors'=>[
                    'required'=>'Please enter phone number',
                ],
            ],
            'email' => [
                'rules'=>[
                    'required',
                    'valid_email',
                    'is_unique[customer_contact_information.email,customer_id,{customer_id}]',
                ],
                'errors'=>[
                    'required'=>'Please enter email address',
                    'valid_email'=>'Please enter valid email',
                    'is_unique'=>'This Email already exists!',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation){
            if($id == ''){  
                //insert
                //check if customer has active contact information records stored
                $has_contact_data = $this->customer_contact_information->getSpecificCustomerDefaultContactInfo($this->request->getVar('customer_id'));
                if(count($has_contact_data) > 0){
                    $is_default = 0;//$this->request->getVar('is_default');
                }
                else{
                    $is_default = 1;
                }
                $data = [
                    'customer_id' => $this->request->getVar('customer_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number'  => $this->request->getVar('phone_number'),
                    'email'  => $this->request->getVar('email'),
                    'is_default'  => $is_default,
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' => $user_info->UserID,
                ];
                $this->customer_contact_information->insertData($data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'Customer contact details saved successfully.');
            }
            else{   
                //update
                $data = [
                    'customer_id' => $this->request->getVar('customer_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number'  => $this->request->getVar('phone_number'),
                    'email'  => $this->request->getVar('email'),
                    'is_default'  => $this->request->getVar('is_default'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' => $user_info->UserID,
                ];
                $this->customer_contact_information->updateData($id, $data);
                // Set the success flash message
                $session->setFlashdata('title', 'Updated');
                $session->setFlashdata('message', 'Customer contact details updated successfully.');
            }
            return $this->response->redirect(site_url('/customer_contact_information'));
        }
        else{
            $user_info = getUserInfo();
            $records['CustomerContactInformation'] = $this->customer_contact_information->index();
            $has_errors = 'true';
            $customers = $this->customer->index();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'CustomerContactInformation',
                'link' => 'customer_contact_information',
                'sources' => $records,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'customers' => $customers,
            );
            return view('/customer_contact_information', $data);
        }
     }
    //get specific data
    public function getSpecificData($id = null) 
    {
        $data=$this->customer_contact_information->getSpecificData($id);
        $customer_id = ($this->common->getSpecificColumnValueByGivenColumnName('customer_contact_information','id','customer_id',$id,'delete_flag',0))->customer_id;
        $customer_default_contact_data = count($this->customer_contact_information->getSpecificCustomerDefaultContactInfo($customer_id));
        if($data){
            echo json_encode(array("status" => true , 'data' => $data,'customer_default_contact_data' => $customer_default_contact_data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['CustomerContactInformation'] = $this->customer_contact_information->index();
        $has_errors = 'false';
        $customers = $this->customer->indexActiveData();
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'CustomerContactInformation',
            'link' => 'customer_contact_information',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'customers' => $customers,
        );
        return view('customer_contact_information', $data);
    }
    // delete data
    public function delete($id = null)
    {
        $user_info = getUserInfo();   
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'deleted_by' => $user_info->UserID,
            'delete_flag' => 1,
        ];
        $this->customer_contact_information->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
    //change customer contact info default status
    public function changeCustomerContactInfoDefaultStatus($id = null)
    {
        $data = [
            'is_default' => 0,
        ];
        $customer_id = ($this->common->getSpecificColumnValueByGivenColumnName('customer_contact_information','id','customer_id',$id,'delete_flag',0))->customer_id;
        $countCustomersAddresses = $this->customer_contact_information->checkCustomerCount($customer_id);        
        // var_dump($countCustomersAddresses);
        if($countCustomersAddresses != 1){
            //var_dump($countCustomersAddresses);
            $change_status =  $this->customer_contact_information->changeCustomerContactInfoDefaultStatus($id,$customer_id,$data);
        
            if($change_status){
                return $this->response->setJSON([
                    'error' => false,
                    'icon' => 'success',
                    'title' => 'Updated',
                    'message' => 'Customer contact details updated Successfully!'
                ]);
            }
        }else{            
            return $this->response->setJSON([
                'error' => false,
                'icon' => 'error',
                'title' => 'Unable to delete the record',
                'message' => 'Customer have only one address.'
            ]);
        }
    } 
    //get specific customer data
    public function getSpecificContactInfo($id = null)
    {
        $customer_id = ($this->common->getSpecificColumnValueByGivenColumnName('customer_contact_information','id','customer_id',$id,'delete_flag',0))->customer_id;
        $user_info = getUserInfo();
        $records['SpecificCustomerContactInformation'] = $this->customer_contact_information->getSpecificCustomerContactInfo($customer_id);
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'SpecificCustomerContactInformation',
            'link' => 'specific_customer_contact_information',
            'sources' => $records,
            'userinfo' => $user_info,
        );
        return view('specific_customer_contact_information', $data);
    }
    // update default data
    public function updateDefaultData()
    {
        $id = $this->request->getVar('id');
        $data = [
            'is_default' => $this->request->getVar('is_default'),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        $this->customer_contact_information->updateDefaultData($id,$data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully updated!'
        ]);
    } 
    //search customer by phone number
    public function searchCustomerByPhoneNumber($customer_phone_number = null)
     {
        $data=$this->customer_contact_information->searchCustomerByPhoneNumber($customer_phone_number);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
}
