<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */


// We get a performance increase by specifying the default
// route since we don't have to scan directories.

//Already Logged In
$routes->group('', ['filter'=>'AlreadyLoggedIn'], function($routes){
    //login
    $routes->get('/', 'Auth::index');
    $routes->get('/auth', 'Auth::index');
    $routes->post('/check', 'Auth::check');
});

//authentication
$routes->group('', ['filter'=>'AuthCheck','filter'=>'permissionCheck'], function($routes){
// $routes->group('', ['filter'=>'AuthCheck'], function($routes){
    //----------------------routes: start ----------------------------------------
    //--home route--
    $routes->get('/index', 'Home::index');
    //--logout route--
    $routes->get('/logout', 'Auth::logout');
    //--user routes--
    $routes->get('/user', 'UserController::getUsers');
    $routes->get('user_modify_sale_check_authorization/(:num)', 'UserController::ModifySaleCheckAuthorization/$1');
    // $routes->get('user_delete/(:num)', 'UserController::delete/$1');
    //--supplier routes--
    $routes->get('/suppliers', 'SuppliersController::index');
    $routes->post('/supplier_save', 'SuppliersController::save');
    $routes->get('supplier_edit/(:num)', 'SuppliersController::singleData/$1');
    $routes->get('supplier_delete/(:num)', 'SuppliersController::delete/$1');
    $routes->get('disable_supplier/(:num)', 'SuppliersController::disablesupplier/$1');
    $routes->get('enable_supplier/(:num)', 'SuppliersController::enablesupplier/$1');
    //--manufacturer routes--
    // $routes->get('/manufacturers', 'ManufacturerController::index');
    // $routes->post('/manufactureSave', 'ManufacturerController::save');
    // $routes->get('manufacture/edit/(:num)', 'ManufacturerController::singleData/$1');
    // $routes->post('manufacturer/update', 'ManufacturerController::update');
    // $routes->get('manufacturer/delete/(:num)', 'ManufacturerController::delete/$1');
    //--employee routes--
    $routes->get('/employees', 'EmployeeController::index');
    $routes->post('/employee_save', 'EmployeeController::save');
    $routes->get('employees_edit/(:num)', 'EmployeeController::singleData/$1');
    $routes->get('employees_delete/(:num)', 'EmployeeController::delete/$1');
    $routes->get('disable_employee/(:num)', 'EmployeeController::disableemployee/$1');
    $routes->get('enable_employee/(:num)', 'EmployeeController::enableemployee/$1');
    //--item routes--
    $routes->get('/items', 'ItemsController::index');
    $routes->post('/item_save', 'ItemsController::save');
    $routes->get('item_edit/(:num)', 'ItemsController::singleData/$1');
    $routes->get('item_delete/(:num)', 'ItemsController::delete/$1');
    $routes->get('off_serialize/(:num)', 'ItemsController::offserialize/$1');
    $routes->get('on_serialize/(:num)', 'ItemsController::onserialize/$1');
    $routes->get('disable_item/(:num)', 'ItemsController::disableitem/$1');
    $routes->get('enable_item/(:num)', 'ItemsController::enableitem/$1');
    $routes->get('item_get_item_data/(:num)', 'ItemsController::getItemData/$1');
    //--category routes--
    $routes->post('/insert_category', 'ItemCategoryController::insert');
    $routes->get('category_edit/(:num)', 'ItemCategoryController::singleData/$1');
    $routes->get('category_delete/(:num)', 'ItemCategoryController::delete/$1');
    // --catergory information --
    $routes->get('/item_category_information', 'ItemsCategoryInfomationController::index');
    $routes->post('/insert_category_info', 'ItemsCategoryInfomationController::insert');
    $routes->get('/item_category_infomation_edit/(:num)', 'ItemsCategoryInfomationController::singleData/$1');
    $routes->post('/item_category_infomation_update', 'ItemsCategoryInfomationController::update');
    $routes->get('item_category_infomation_delete/(:num)', 'ItemsCategoryInfomationController::delete/$1');
    $routes->get('disable_item_category/(:num)', 'ItemsCategoryInfomationController::disableItemCatgory/$1');
    $routes->get('enable_item_category/(:num)', 'ItemsCategoryInfomationController::enableItemCatgory/$1');
    //--report routes--
    $routes->get('/reports', 'ReportsController::index');
    //--receiving routes--
    $routes->get('/receivings', 'ReceivingsController::index');
    $routes->get('receivings_feeditemdata/(:num)', 'ReceivingsController::singleItemData/$1');
    $routes->post('/itemsaveandrec', 'ItemsController::saveandrec');   
    $routes->post('/recevingfinish', 'ReceivingsController::saveRecItem');
    $routes->get('receivings_view/(:num)', 'ReceivingsController::getSpecificRecData/$1');
    //$routes->get('searchItem', 'ReceivingsController::searchItem');
    //--temp receiving routes--    
    $routes->get('/receivingsTempList', 'TempReceivingController::index');
    $routes->post('/receivingSerialTempSave', 'TempReceivingController::saveTempRecItem');
    $routes->get('receivingsTempEdit/(:num)', 'TempReceivingController::singleRecData/$1');
    $routes->post('/receivingsTempSaveFromTemp', 'TempReceivingController::saveRecItemFromTemp');
    $routes->post('/receivingsUpdateTemp', 'TempReceivingController::updateTemp');
    $routes->post('/receivingsTempDiscardData', 'TempReceivingController::discardData');
    $routes->get('/receiving_temp_serial_data_item_id/(:num)/(:num)', 'TempReceivingController::singleserialDataByItemCartID/$1/$2');
    //--config routes--
    $routes->get('/config', 'ConfigController::index');
    //--bank routes--
    $routes->get('/banks', 'BanksController::index');
    $routes->post('/submit_banks', 'BanksController::insert');
    $routes->get('banks_edit/(:num)', 'BanksController::singleData/$1');
    $routes->get('banks_delete/(:num)', 'BanksController::delete/$1');
    $routes->get('enable_bank/(:num)', 'BanksController::enablebank/$1');
    $routes->get('disable_bank/(:num)', 'BanksController::disablebank/$1');
    //--functionality routes--
    $routes->get('/functionality', 'FunctionalityController::index');
    $routes->post('/submit_functionality', 'FunctionalityController::insert');
    $routes->get('functionality_edit/(:num)', 'FunctionalityController::singleData/$1');
    $routes->get('functionality_delete/(:num)', 'FunctionalityController::delete/$1');
    $routes->get('enable_functionality/(:num)', 'FunctionalityController::enablefunctionality/$1');
    $routes->get('disable_functionality/(:num)', 'FunctionalityController::disablefunctionality/$1');
    //--user role routes--
    $routes->get('/userroles', 'UserRoleController::index');
    $routes->post('/submit_userrole', 'UserRoleController::insert');
    $routes->get('userrole_edit/(:num)', 'UserRoleController::singleData/$1');
    $routes->get('userrole_delete/(:num)', 'UserRoleController::delete/$1');
    $routes->get('disable_user_role/(:num)', 'UserRoleController::disableuserrole/$1');
    $routes->get('enable_user_role/(:num)', 'UserRoleController::enableuserrole/$1');
    //--user permission routes--
    $routes->get('/userpermissions', 'UserPermissionsController::index');
    $routes->post('/submit_userpermissions', 'UserPermissionsController::insert');
    $routes->get('userpermissions_edit/(:num)', 'UserPermissionsController::singleData/$1');
    $routes->post('userpermissions_update', 'UserPermissionsController::update');
    $routes->get('userpermissions_delete/(:num)', 'UserPermissionsController::delete/$1');
    //--tenant routes--
    $routes->get('/tenant', 'TenantController::index');
    $routes->post('/submit_tenant', 'TenantController::register');
    $routes->get('/tenant_edit/(:num)', 'TenantController::singleData/$1');
    $routes->get(' tenant_delete/(:num)', 'TenantController::delete/$1');
    $routes->get('/disable_tenant/(:num)', 'TenantController::disabletenant/$1');
    $routes->get(' enable_tenant/(:num)', 'TenantController::enabletenant/$1');
    // --discounts routes--
    $routes->get('/discount_type', 'DiscountTypeController::index');
    $routes->post('/submit_discount_type', 'DiscountTypeController::register');
    $routes->get('/discount_type_edit/(:num)', 'DiscountTypeController::singleData/$1');
    $routes->get('/discount_type_delete/(:num)', 'DiscountTypeController::delete/$1');
    $routes->get('/disable_discount_type/(:num)', 'DiscountTypeController::disablediscounttype/$1');
    $routes->get('/enable_discount_type/(:num)', 'DiscountTypeController::enablediscounttype/$1');
    // $routes->get('/tenantthank', 'TenantController::thankyou');
    //-- Bin Locations - Location Based--
    $routes->get('/locationsview', 'LocationsController::index');
    $routes->post('/submit_location', 'LocationsController::locationInsert');
    $routes->get('/delete_location/(:num)', 'LocationsController::locationDelete/$1');
    $routes->get('/location_single_data/(:num)', 'LocationsController::locationSingleData/$1');
    // --Item location bin--
    $routes->get('/locations', 'ItemLocationsController::index');
    $routes->get('/single_stock_data/(:num)', 'ItemLocationsController::stockSingleData/$1');
    $routes->post('/bin_insert', 'ItemLocationsController::insert');
    $routes->get('/location_bin_single_data/(:num)', 'ItemLocationsController::locationBinSingleData/$1');
    $routes->get('/location_bin_delete/(:num)', 'ItemLocationsController::locationBinDelete/$1');
    //-- Bin Locations - Bin Based--
    $routes->post('/bin_insert', 'LocationsController::binInsert');
    $routes->get('/bin_delete/(:num)', 'LocationsController::binDelete/$1');
    $routes->get('/bin_single_data/(:num)', 'LocationsController::binSingleData/$1');
    //--customer routes--
    $routes->get('/customer', 'CustomerController::index');
    $routes->post('submit_customer', 'CustomerController::submit');
    $routes->get('customer_edit/(:num)', 'CustomerController::getSpecificData/$1');
    $routes->get('customer_delete/(:num)', 'CustomerController::delete/$1');
    $routes->get('enable_customer/(:num)', 'CustomerController::enablecustomer/$1');
    $routes->get('disable_customer/(:num)', 'CustomerController::disablecustomer/$1');
    //--customer contact info routes--
    $routes->get('/customer_contact_information', 'CustomerContactInformationController::index');
    $routes->post('submit_customer_contact_information', 'CustomerContactInformationController::submit');
    $routes->get('customer_contact_information_edit/(:num)','CustomerContactInformationController::getSpecificData/$1');
    $routes->get('customer_contact_information_delete/(:num)', 'CustomerContactInformationController::delete/$1');
    $routes->get('customer_contact_information_change_customer_contact_info_default_status/(:num)', 'CustomerContactInformationController::changeCustomerContactInfoDefaultStatus/$1');
    $routes->get('customer_contact_information_get_specific_customer_default_contact_info/(:num)', 'CustomerContactInformationController::getSpecificCustomerDefaultContactInfo/$1');
    $routes->get('/get_customer_contact_information/(:num)', 'CustomerContactInformationController::getSpecificContactInfo/$1');
    $routes->post('customer_contact_information_update_default_data', 'CustomerContactInformationController::updateDefaultData');
    $routes->get('/search_customer_by_phone_number/(:num)', 'CustomerContactInformationController::searchCustomerByPhoneNumber/$1');
    //--delivery routes--
    $routes->get('/delivery', 'DeliveryController::index');
    $routes->post('submit_delivery', 'DeliveryController::submit');
    $routes->get('delivery_edit/(:num)', 'DeliveryController::getSpecificData/$1');
    $routes->get('delivery_delete/(:num)', 'DeliveryController::delete/$1');
    $routes->get('disable_delivery/(:num)', 'DeliveryController::disabledelivery/$1');
    $routes->get('enable_delivery/(:num)', 'DeliveryController::enabledelivery/$1');
    //--loyalties routes--
    $routes->get('/loyalties', 'LoyaltiesController::index');
    $routes->post('submit_loyalties', 'LoyaltiesController::submit');
    $routes->get('loyalties_edit/(:num)', 'LoyaltiesController::getSpecificData/$1');
    $routes->get('loyalties_delete/(:num)', 'LoyaltiesController::delete/$1');
    $routes->get('disable_loyalty/(:num)', 'LoyaltiesController::disableloyalty/$1');
    $routes->get('enable_loyalty/(:num)', 'LoyaltiesController::enableloyalty/$1');
    //--terminal routes--
    $routes->get('/terminal', 'TerminalController::index');
    $routes->post('submit_terminal', 'TerminalController::submit');
    $routes->get('terminal_edit/(:num)', 'TerminalController::getSpecificData/$1');
    $routes->get('terminal_delete/(:num)', 'TerminalController::delete/$1');
    $routes->get('enable_terminal/(:num)', 'TerminalController::enableterminal/$1');
    $routes->get('disable_terminal/(:num)', 'TerminalController::disableterminbal/$1');
    // --pricerules routes--
    $routes->get('/pricerules', 'PriceRulesController::index');
    $routes->post('/submit_price_rules', 'PriceRulesController::submit');
    $routes->get('price_rules_edit/(:num)', 'PriceRulesController::getSpecificData/$1');
    $routes->get('price_rule_delete/(:num)', 'PriceRulesController::delete/$1');
    // --gift card routes--
    $routes->get('/gift_card', 'GiftCardController::index');
    $routes->post('/submit_gift_card', 'GiftCardController::submit');
    $routes->get('gift_card_edit/(:num)', 'GiftCardController::singleData/$1');
    $routes->get('gift_card_delete/(:num)', 'GiftCardController::delete/$1');
    $routes->get('gift_card_check_voucher_validity/(:num)/(:num)', 'GiftCardController::checkVoucherValidity/$1/$2');
    $routes->get('/gift_voucher_sale', 'GiftCardController::giftVoucherSaleIndex');
    $routes->post('submit_gift_voucher_sale', 'GiftCardController::giftVoucherSaleSubmit');
    $routes->get('view_gift_voucher_sale/(:num)', 'GiftCardController::getSpecificVoucherSaleData/$1');
    $routes->get('disable_gift_card/(:num)', 'GiftCardController::disablegiftcard/$1');
    $routes->get('enable_gift_card/(:num)', 'GiftCardController::enablegiftcard/$1');
    // --card promotion crud--
    $routes->get('/card_promotion', 'CardPromotionController::index');
    $routes->post('/submit_card_promotion', 'CardPromotionController::submit');
    $routes->get('card_promotion_edit/(:num)', 'CardPromotionController::singleData/$1');
    $routes->get('/card_promotion_delete/(:num)', 'CardPromotionController::delete/$1');
    //--sale routes--
    // $routes->get('/sales', 'SalesController::index', ["filter" => "permissionCheck"]);
    $routes->get('/sales', 'SalesController::index');
    $routes->post('submit_sale', 'SalesController::submit');
    $routes->get('view_sales/(:num)', 'SalesController::getSpecificSaleData/$1');
    //--customer_loyalties routes--
    $routes->get('set_customer_loyalty_redeem_data/(:num)/(:num)', 'CustomerLoyaltiesController::setCustomerLoyaltyRedeemData/$1/$2');
    //--item_serialized routes--
    $routes->get('/get_serialzed_item_warranty_period/(:num)', 'ItemSerialDataController::getWarrantyPeriod/$1');
    //----------------------routes: end ----------------------------------------
    // /uPupdate
    //sales
    $routes->resource('Api/sales');
    //users
    $routes->resource('Api/user');
    //supplier
    $routes->resource('Api/supplier');
    //inventory
    $routes->resource('Api/inventory');
    // unit and measure
    $routes->get('/unitandmeatures', 'UnitandMeaturesController::index');
    $routes->post('/submit_unit', 'UnitandMeaturesController::addupUnits');
    $routes->get('/unit_edit/(:num)', 'UnitandMeaturesController::singleUnits/$1');
    $routes->get('/unit_delete/(:num)', 'UnitandMeaturesController::deleteUnit/$1');
    $routes->get('enable_unit/(:num)', 'UnitandMeaturesController::enableunit/$1');
    $routes->get('disable_unit/(:num)', 'UnitandMeaturesController::disableunit/$1');
    // conversion factors
    $routes->get('/conversion_factor', 'ConversionFactorController::index');
    $routes->post('/submit_conversion_factor', 'ConversionFactorController::addupCFs');
    $routes->get('conversion_factor_edit/(:num)', 'ConversionFactorController::singleCFs/$1');
    $routes->get('conversion_factor_delete/(:num)', 'ConversionFactorController::deleteCF/$1');
    $routes->get('disable_conversion_factor/(:num)', 'ConversionFactorController::disableconversionfactor/$1');
    $routes->get('enable_conversion_factor/(:num)', 'ConversionFactorController::enableconversionfactor/$1');
    // master config
    $routes->get('/masterconfig', 'MasterConfigController::index');
    $routes->get('/get_masterconfig_data', 'MasterConfigController::getMasterConfigData'); //get location data to edit location functionality
    $routes->post('/submit_masterconfig_data', 'MasterConfigController::insert');
    $routes->get('/masterconfig_edit/(:num)', 'MasterConfigController::singleData/$1');
    $routes->get('masterconfig_delete/(:num)', 'MasterConfigController::delete/$1');
    // Payment_Types
    $routes->get('/payment_types', 'PaymentTypesController::index');
    $routes->post('/submit_payment_types', 'PaymentTypesController::submit');
    $routes->get('/payment_type_edit/(:num)', 'PaymentTypesController::singleData/$1');
    $routes->get('/payment_type_delete/(:num)', 'PaymentTypesController::delete/$1');
    $routes->get('/enable_payment_type/(:num)', 'PaymentTypesController::enablepaymenttypes/$1');
    $routes->get('/disable_payment_type/(:num)', 'PaymentTypesController::disablepaymenttypes/$1');
    // price management
    $routes->get('/price_management', 'PriceManagementController::index');
    $routes->get('/get_price_detail', 'PriceManagementController::getPriceDetails');
    $routes->post('/save_price_detail', 'PriceManagementController::savePriceDetails');
     // user
     $routes->get('/user_detail', 'UserController::index');
     $routes->get('user_delete/(:num)', 'UserController::delete/$1');
     $routes->get('disable_user/(:num)', 'UserController::disableuser/$1');
     $routes->get('enable_user/(:num)', 'UserController::enableuser/$1');
      // stock
      $routes->get('/stock', 'StockManagementController::index');
      $routes->get('/stock_delete/(:num)', 'StockManagementController::delete/$1');
      //payment terms
      $routes->get('/payment_terms', 'PaymentTermController::index');
      $routes->post('/submit_payment_terms', 'PaymentTermController::submit');
      $routes->get('/payment_terms_edit/(:num)', 'PaymentTermController::singleData/$1');
      $routes->get('payment_terms_delete/(:num)', 'PaymentTermController::delete/$1');
      $routes->get('enable_payment_terms/(:num)', 'PaymentTermController::enablepaymentterms/$1');
      $routes->get('disable_payment_terms/(:num)', 'PaymentTermController::disablepaymentterms/$1');
});

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
