<?php

namespace App\Controllers;
use App\Models\UserRoleModel;
use App\Models\UserModel;
use App\Models\CommonModel;
use App\Controllers\BaseController;

class UserRoleController extends BaseController
{
    public function __construct()
    {        
        $this->userroleModel = new UserRoleModel();
        $this->common = new CommonModel(); 
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }
    // insert data
    public function insert()
    {
        $user_info = getUserInfo();   
        $validation = $this->validate([
            'URName' => [
                'rules'=>'required|is_unique[userrole.URName,URoleID,{URoleID}]',
                'errors'=>[
                    'required'=>'Uname is required',
                    'is_unique'=>'This User Role already exists!',
                ],
            ],
        ]);
        $uroleId = $this->request->getVar('URoleID');
        $session = session();
        if($validation){   
            if($uroleId == ''){  //insert userrole details      
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'delete_flag' => '0',
                    'URCreatedAt'=>date('Y-m-d H:i:s'),
                    'URCreatedBy'=>$user_info->UserID,
                ]; 
                //set trans status
                $transaction_status = false;
                //---begin transaction---
                $this->db->transBegin();
                $this->userroleModel->insertuRoleData($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'User Role  details saved successfully.'); 
                }     
            }
            else{      //update userrole details
                $data = [
                    'URName' => $this->request->getVar('URName'),
                    'URUpdatedAt' => date('Y-m-d H:i:s'),
                    'URUpdatedBy'=>$user_info->UserID,
                ];        
                $this->userroleModel->updateUrole($uroleId, $data);
                 // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('icon', 'success');
            $session->setFlashdata('message', 'Userrole details updated successfully.');
            }
             return $this->response->redirect(site_url('/userroles'));
                 }
        else{
            $has_errors = 'true';
            $user_info = getUserInfo(); 
            $urs['UserRoles']= $this->userroleModel->getUrolesIndexData();
            $data = [
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'breadcrumbs' => 'true',
                'title' => 'User Roles',
                'link' => 'userroles',
                'sources' => $urs,
                'userinfo' => $user_info
            ];
            return view('/userroles', $data); 
        }
    }
   //get index data
    public function index()
    {
        $user_info = getUserInfo();
        $urs['UserRoles']= $this->userroleModel->getUrolesIndexData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'User Roles',
            'link' => 'userroles',
            'sources' => $urs,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('userroles', $data);
    }
    //get single data
    public function singleData($id = null) 
    {        
        $data= $this->userroleModel->getSingleuRoleData($id);
        if($data){
            echo json_encode(array("status" => true, 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo();   
        $has_user_info = $this->common->checkForeignKeyConstraints("user","UserRole",$id,"delete_flag",0);
        $has_rulebook_info = $this->common->checkForeignKeyConstraints("rulebook","RoleID",$id,"delete_flag",0);
        $now = date("Y-m-d H:i:s");
        //define message
        $msg_prefix = 'This user role has ';
        $msg_user_info = 'user information';
        $msg_rulebook_info = ' rulebook information ';
        $msg = '';
        if($has_user_info && $has_rulebook_info ){
            $msg = $msg_prefix.$msg_user_info.','.$msg_rulebook_info;
        }
        else{
            if($has_user_info && !($has_rulebook_info)){
                $msg = $msg_prefix.$msg_user_info;
            }
            else if($has_rulebook_info && !($has_user_info)){
                $msg = $msg_prefix.$msg_rulebook_info;
            }
        }
        $data = [
            'URDeletedAt' => $now,
            'URDeletedBy'=>$user_info->UserID,
            'delete_flag' => '1',
        ];

        if($has_user_info || $has_rulebook_info){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->userroleModel->deleteUrole($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }

        // $UserRoleModel->update($id, $data);
        // $this->userroleModel->deleteUrole($id, $data);
        // return $this->response->setJSON([
        //     'error' => false,
        //     'message' => 'Successfully deleted!'
        // ]);
        //return $this->response->redirect(site_url('/functionality'));
    } 

      // userrole disable
      public function disableuserrole($id = null)
      {
        
          $data = [
              'current_status' => '2'
          ];    
         
          if($this->userroleModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
      // userrole enable
      public function enableuserrole($id = null)
      {
          $data = [
              'current_status' => '1'
          ];
          if($this->userroleModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
}
