<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CardPromotionDetail extends Migration
{
    public function up()
    {
         //Create cardPromotion Table
         $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'bank_name' => [
                'type' => 'INT'
            ],
            'amount' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'start_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'end_date'=> [
                'type' => 'DATE',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('card_promotion');
    }

    public function down()
    {
             //Drop Table
         $this->forge->dropTable('card_promotion');
    }
}
