<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Payment extends Migration
{
    public function up()
    {
        //Create Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'sale_id' => [
                'type' => 'INT',
            ],
            'customer_id' => [
                'type' => 'INT',
            ],
            'amount' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'payment_type_id' => [
                'type' => 'INT',
            ],
            'bank_id' => [
                'type' => 'INT',
                'null' => true,
            ],
            'payment_method_id' => [
                'type' => 'INT',
                'null' => true,
            ],
            'card_expiration_date'=>[
                'type' => 'Date',
                'null' => true,
            ],
            'reference_number' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
                'comment' => 'cheque: cheque number, card: card number, gift voucher: voucher ref number, loyality: loyality card number',
            ],
            'remarks' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'payment_authorized_by_id' => [
                'type' => 'INT',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('payments');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('payments');
    }
}