<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemUnits extends Migration
{
    public function up()
    {
        //Create stocks table
        $this->forge->addField([
            'ItemUnitID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'OtherUnits' => [
                'type' => 'varchar',
                'constraint' => 10,
            ],
            'ItemUnitStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ]
        ]);

        $this->forge->addPrimaryKey('ItemUnitID');
        $this->forge->createTable('itemunits');
    }

    public function down()
    {
        //Drop stocks Table
        $this->forge->dropTable('itemunits');
    }
}
